/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class RechiseledBakedModel
implements IDynamicBakedModel {
    private final Map<Direction, List<Tuple<BakedQuad, Boolean>>> quads;
    private final boolean ambientOcclusion;
    private final boolean gui3d;
    private final boolean blockLighting;
    private final boolean customRenderer;
    private final TextureAtlasSprite particles;
    private final ItemOverrideList itemOverrides;
    private final ItemCameraTransforms transforms;

    public RechiseledBakedModel(Map<Direction, List<Tuple<BakedQuad, Boolean>>> quads, boolean ambientOcclusion, boolean gui3d, boolean blockLighting, boolean customRenderer, TextureAtlasSprite particles, ItemOverrideList itemOverrides, ItemCameraTransforms transforms) {
        this.quads = quads;
        this.ambientOcclusion = ambientOcclusion;
        this.gui3d = gui3d;
        this.blockLighting = blockLighting;
        this.customRenderer = customRenderer;
        this.particles = particles;
        this.itemOverrides = itemOverrides;
        this.transforms = transforms;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        List unconnectedQuads = this.quads.getOrDefault(side, Collections.emptyList());
        for (Tuple entry : unconnectedQuads) {
            BakedQuad quad = (BakedQuad)entry.func_76341_a();
            if (((Boolean)entry.func_76340_b()).booleanValue()) {
                int[] vertexData = quad.func_178209_a();
                vertexData = Arrays.copyOf(vertexData, vertexData.length);
                int[] uv = this.getUV(quad.func_178210_d(), extraData);
                RechiseledBakedModel.adjustVertexDataUV(vertexData, uv[0], uv[1], quad.func_187508_a(), DefaultVertexFormats.field_176600_a);
                quads.add(new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_()));
                continue;
            }
            quads.add(quad);
        }
        return quads;
    }

    protected int[] getUV(Direction side, IModelData modelData) {
        return new int[]{0, 0};
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite, VertexFormat vertexFormat) {
        int vertexSize = vertexFormat.func_181719_f();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = RechiseledBakedModel.findUVOffset(vertexFormat) / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.func_94212_f() - sprite.func_94209_e();
            float u = ((float)newU + (Float.intBitsToFloat(vertexData[offset]) - sprite.func_94209_e()) / width) * 2.0f;
            vertexData[offset] = Float.floatToRawIntBits(sprite.func_94214_a((double)u));
            float height = sprite.func_94210_h() - sprite.func_94206_g();
            float v = ((float)newV + (Float.intBitsToFloat(vertexData[offset + 1]) - sprite.func_94206_g()) / height) * 2.0f;
            vertexData[offset + 1] = Float.floatToRawIntBits(sprite.func_94207_b((double)v));
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.func_227894_c_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.func_227894_c_().get(index);
            if (el.func_177375_c() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.func_227894_c_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.func_177367_b() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.func_177368_f() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.getOffset(index);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return super.getModelData(world, pos, state, tileData);
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public boolean func_177556_c() {
        return this.gui3d;
    }

    public boolean func_230044_c_() {
        return this.blockLighting;
    }

    public boolean func_188618_c() {
        return this.customRenderer;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particles;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverrides;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }
}

