/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class PacketChiselingRecipes
implements BasePacket {
    private List<ChiselingRecipe> recipes;

    public PacketChiselingRecipes(List<ChiselingRecipe> recipes) {
        this.recipes = recipes;
    }

    public PacketChiselingRecipes() {
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.recipes.size());
        this.recipes.forEach(recipe -> ChiselingRecipe.Serializer.toNetwork(buffer, recipe));
    }

    public void read(PacketBuffer buffer) {
        this.recipes = new ArrayList<ChiselingRecipe>();
        int recipeCount = buffer.readInt();
        for (int i = 0; i < recipeCount; ++i) {
            this.recipes.add(ChiselingRecipe.Serializer.fromNetwork(buffer));
        }
    }

    public boolean verify(PacketContext context) {
        return context.getHandlingSide() == CoreSide.CLIENT;
    }

    public void handle(PacketContext context) {
        ChiselingRecipes.setRecipes(this.recipes);
    }
}

