/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.chiseling.PacketChiselingRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChiselingRecipeLoader
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)new ChiselingRecipeLoader());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent e) {
        if (e.getPlayer() == null) {
            Rechiseled.CHANNEL.sendToAllPlayers((BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        } else {
            Rechiseled.CHANNEL.sendToPlayer((PlayerEntity)e.getPlayer(), (BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        }
    }

    public ChiselingRecipeLoader() {
        super(GSON, "chiseling_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> entries, IResourceManager resourceManager, IProfiler profilerFiller) {
        HashMap recipes = Maps.newHashMap();
        ArrayList<ChiselingRecipe> recipesWithoutParent = new ArrayList<ChiselingRecipe>();
        ArrayList<ChiselingRecipe> recipesWithParent = new ArrayList<ChiselingRecipe>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            ChiselingRecipe recipe;
            ResourceLocation recipeId = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            try {
                recipe = ChiselingRecipe.Serializer.fromJson(entry.getKey(), json);
            }
            catch (Exception e) {
                System.err.println("Encountered an exception when trying to load chiseling recipe: " + recipeId);
                e.printStackTrace();
                continue;
            }
            recipes.put(recipeId, recipe);
            if (recipe.parentRecipeId == null) {
                recipesWithoutParent.add(recipe);
                continue;
            }
            recipesWithParent.add(recipe);
        }
        int successfullyLoadedRecipes = recipesWithoutParent.size();
        block3: for (ChiselingRecipe recipe : recipesWithParent) {
            HashSet<ResourceLocation> coveredRecipes = new HashSet<ResourceLocation>();
            List<ChiselingEntry> chiselingEntries = recipe.getEntries();
            ChiselingRecipe parentRecipe = recipe;
            while (parentRecipe.parentRecipeId != null) {
                coveredRecipes.add(parentRecipe.getRecipeId());
                ResourceLocation parentId = parentRecipe.parentRecipeId;
                if (coveredRecipes.contains(parentId)) {
                    System.err.println("Found circular parent references when trying to load chiseling recipe: " + recipe.getRecipeId());
                    continue block3;
                }
                parentRecipe = (ChiselingRecipe)recipes.get(parentId);
                if (parentRecipe != null) continue;
                System.err.println("Could not find parent '" + parentId + "' when trying to load chiseling recipe: " + recipe.getRecipeId());
                continue block3;
            }
            parentRecipe.addEntries(chiselingEntries);
            ++successfullyLoadedRecipes;
        }
        System.out.println("Loaded " + successfullyLoadedRecipes + " chiseling recipes");
        ChiselingRecipes.setRecipes(Collections.unmodifiableList(recipesWithoutParent));
    }
}

