/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ChiselingRecipeProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<String, ChiselingRecipeBuilder> recipes = new HashMap<String, ChiselingRecipeBuilder>();

    public ChiselingRecipeProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public String func_200397_b() {
        return "Chiseling Recipes: " + this.modid;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.buildRecipes();
        Path path = this.generator.func_200391_b();
        for (Map.Entry<String, ChiselingRecipeBuilder> entry : this.recipes.entrySet()) {
            String recipeName = entry.getKey();
            ChiselingRecipeBuilder builder = entry.getValue();
            if (builder.parent != null) {
                ResourceLocation parentLocation;
                ResourceLocation parent = builder.parent;
                while (parent != null && parent.func_110624_b().equals(this.modid) && this.recipes.containsKey(parent.func_110623_a())) {
                    parent = this.recipes.get(parent.func_110623_a()).parent;
                }
                if (parent != null && !this.existingFileHelper.exists(parentLocation = new ResourceLocation(parent.func_110624_b(), "chiseling_recipes/" + (parent.func_110623_a().endsWith(".json") ? parent.func_110623_a() : parent.func_110623_a() + ".json")), ResourcePackType.SERVER_DATA)) {
                    throw new IllegalStateException("Could not find upward parent '" + parent + "' at '/data/" + parentLocation.func_110624_b() + "/" + parentLocation.func_110623_a() + "' for chiseling recipe: " + recipeName);
                }
            }
            JsonObject json = ChiselingRecipeProvider.serializeRecipe(recipeName, builder);
            Path recipePath = path.resolve("data/" + this.modid + "/chiseling_recipes/" + recipeName + ".json");
            ChiselingRecipeProvider.saveRecipe(cache, json, recipePath);
        }
    }

    private static JsonObject serializeRecipe(String recipeName, ChiselingRecipeBuilder recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "rechiseled:chiseling");
        if (recipe.parent != null) {
            json.addProperty("parent", recipe.parent.toString());
        }
        HashSet items = Sets.newHashSet();
        JsonArray entries = new JsonArray();
        for (Triple entry : recipe.entries) {
            JsonObject object = new JsonObject();
            if (entry.getLeft() != null) {
                if (!items.add(entry.getLeft())) {
                    throw new IllegalStateException("Duplicate item '" + ((Item)entry.getLeft()).getRegistryName() + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("item", ((Item)entry.getLeft()).getRegistryName().toString());
            }
            if (entry.getMiddle() != null) {
                if (!items.add(entry.getMiddle())) {
                    throw new IllegalStateException("Duplicate item '" + ((Item)entry.getMiddle()).getRegistryName() + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("connecting_item", ((Item)entry.getMiddle()).getRegistryName().toString());
            }
            if (((Boolean)entry.getRight()).booleanValue()) {
                object.addProperty("optional", Boolean.valueOf(true));
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        return json;
    }

    private static void saveRecipe(DirectoryCache cache, JsonObject json, Path path) {
        try {
            String jsonString = GSON.toJson((JsonElement)json);
            String hash = field_208307_a.hashUnencodedChars((CharSequence)jsonString).toString();
            if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(jsonString);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException exception) {
            System.err.println("Couldn't save recipe '" + path + "'");
            exception.printStackTrace();
        }
    }

    private boolean validateRecipe(ResourceLocation recipe) {
        return this.existingFileHelper.exists(recipe, ResourcePackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    private void trackRecipe(String recipe) {
        this.existingFileHelper.trackGenerated(new ResourceLocation(this.modid, recipe), ResourcePackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    protected abstract void buildRecipes();

    protected ChiselingRecipeBuilder beginRecipe(String recipeName) {
        this.trackRecipe(recipeName);
        return this.recipes.computeIfAbsent(recipeName, s -> new ChiselingRecipeBuilder());
    }

    protected class ChiselingRecipeBuilder {
        private final List<Triple<Item, Item, Boolean>> entries = new LinkedList<Triple<Item, Item, Boolean>>();
        private ResourceLocation parent;

        private ChiselingRecipeBuilder() {
        }

        public ChiselingRecipeBuilder parent(ResourceLocation parent) {
            if (!ChiselingRecipeProvider.this.validateRecipe(parent)) {
                throw new IllegalArgumentException("Could not find parent recipe '" + parent + "'!");
            }
            this.parent = parent;
            return this;
        }

        public ChiselingRecipeBuilder add(@Nullable Item regularItem, @Nullable Item connectingItem, boolean optional) {
            if (regularItem == null && connectingItem == null) {
                throw new IllegalArgumentException("At least one of regular item or connecting item must not be null!");
            }
            this.entries.add((Triple<Item, Item, Boolean>)new ImmutableTriple((Object)regularItem, (Object)connectingItem, (Object)optional));
            return this;
        }

        public ChiselingRecipeBuilder add(Item regularItem, Item connectingItem) {
            return this.add(regularItem, connectingItem, false);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(item, null, optional);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item) {
            return this.addRegularItem(item, false);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(null, item, optional);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item) {
            return this.addConnectingItem(item, false);
        }
    }
}

