/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.morefurniture.datagen;

import com.mrcrayfish.furniture.common.ModTags;
import com.mrcrayfish.morefurniture.Generator;
import com.mrcrayfish.morefurniture.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.TagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class BlockTagGen
extends BlockTagsProvider {
    public BlockTagGen(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "morecfm", existingFileHelper);
    }

    private static Block getResultBlock(Generator.Variant variant, Generator.FurnitureType type, boolean stripped) {
        try {
            String fieldFormat = stripped ? "%s_%s_STRIPPED_%s" : "%s_%s_%s";
            String fieldName = String.format(fieldFormat, variant.getLog().getRegistryName().func_110624_b().toUpperCase(), type.getId().toUpperCase(), variant.getId().toUpperCase());
            RegistryObject block = (RegistryObject)ModBlocks.class.getField(fieldName).get(null);
            return (Block)block.get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void func_200432_c() {
        Generator generator = new Generator();
        TagsProvider.Builder upgradedFences = this.func_240522_a_(ModTags.Blocks.UPGRADED_FENCES).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            upgradedFences.addOptional(BlockTagGen.getResultBlock(variant, Generator.UPGRADED_FENCE, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            upgradedFences.addOptional(BlockTagGen.getResultBlock(variant, Generator.UPGRADED_FENCE, true).getRegistryName());
        }
        TagsProvider.Builder upgradedGates = this.func_240522_a_(ModTags.Blocks.UPGRADED_FENCE_GATES).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            upgradedGates.addOptional(BlockTagGen.getResultBlock(variant, Generator.UPGRADED_GATE, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            upgradedGates.addOptional(BlockTagGen.getResultBlock(variant, Generator.UPGRADED_GATE, true).getRegistryName());
        }
    }
}

