/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.datagen;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.data.CustomConversionProvider;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class PEICustomConversionProvider
extends CustomConversionProvider {
    private static final Type CONVERSION_PROVIDER_TYPE = Type.getType(ConversionProvider.class);

    protected PEICustomConversionProvider(DataGenerator generator) {
        super(generator);
    }

    private static NormalizedSimpleStack gemTag(String gem) {
        return PEICustomConversionProvider.tag("forge:gems/" + gem);
    }

    private static NormalizedSimpleStack tag(String tag) {
        return NSSItem.createTag((ResourceLocation)new ResourceLocation(tag));
    }

    private static NormalizedSimpleStack ingotTag(String ingot) {
        return PEICustomConversionProvider.tag("forge:ingots/" + ingot);
    }

    protected void addCustomConversions() {
        this.createConversionBuilder(new ResourceLocation("projecteintegration", "pei_metals")).before(PEICustomConversionProvider.ingotTag("zinc"), 128L).before(new FluidStack((Fluid)Fluids.field_204546_a, 250), 1L);
        for (Map.Entry<AConversionProvider, String> entry : this.getConversionProviders().entrySet()) {
            ResourceLocation resourceLocation = new ResourceLocation(entry.getValue(), entry.getValue() + "_default");
            PEIntegration.debugLog("Add custom conversions for {}", resourceLocation);
            CustomConversionBuilder builder = this.createConversionBuilder(resourceLocation);
            entry.getKey().convert(builder);
        }
    }

    private Map<AConversionProvider, String> getConversionProviders() {
        ModList modList = ModList.get();
        HashMap<AConversionProvider, String> conversionProviders = new HashMap<AConversionProvider, String>();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                Map annotationData;
                AConversionProvider provider;
                if (!CONVERSION_PROVIDER_TYPE.equals((Object)data.getAnnotationType()) || (provider = this.createInstance(data.getMemberName())) == null || !(annotationData = data.getAnnotationData()).containsKey("value")) continue;
                conversionProviders.put(provider, (String)annotationData.get("value"));
            }
        }
        return conversionProviders;
    }

    private AConversionProvider createInstance(String className) {
        try {
            return Class.forName(className).asSubclass(AConversionProvider.class).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            PEIntegration.LOGGER.error("Failed to load conversion provider: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

