/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.recipe;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ABaseRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Tuple;

public abstract class ARecipeTypeMapper<R extends IRecipe<?>>
extends ABaseRecipeMapper<R>
implements IRecipeTypeMapper {
    public final boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager fakeGroupManager) {
        this.mapper = mapper;
        this.fakeGroupManager = fakeGroupManager;
        this.recipeID = iRecipe.func_199560_c();
        try {
            return this.convertRecipe(iRecipe);
        }
        catch (ClassCastException e) {
            PEIntegration.LOGGER.fatal("RecipeMapper ({}) is unable to handle recipe ({}), expected ({})", (Object)this.getClass().getName(), (Object)iRecipe.getClass().getName(), (Object)((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getTypeName());
        }
        catch (Exception e) {
            PEIntegration.LOGGER.fatal("RecipeMapper ({}) failed unexpectedly during the handling of recipe '{}' ({}).", (Object)this.getClass().getName(), (Object)this.recipeID, (Object)iRecipe.getClass().getName(), (Object)e);
        }
        return false;
    }

    @Override
    public NSSOutput getOutput(R recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output.func_190926_b()) {
            return null;
        }
        return new NSSOutput(output);
    }

    protected List<Ingredient> getIngredients(R recipe) {
        return recipe.func_192400_c();
    }

    @Override
    public NSSInput getInput(R recipe) {
        List<Ingredient> ingredients = this.getIngredients(recipe);
        if (ingredients == null || ingredients.isEmpty()) {
            PEIntegration.debugLog("Recipe ({}) contains no inputs: {}", this.recipeID, ingredients);
            return null;
        }
        ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
        IngredientMap ingredientMap = new IngredientMap();
        for (Ingredient ingredient : ingredients) {
            if (this.convertIngredient(ingredient, (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
        }
        return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
    }

    @Override
    public String[] getRequiredMods() {
        RecipeTypeMapper recipeTypeMapperAnnotation = this.getClass().getAnnotation(RecipeTypeMapper.class);
        if (recipeTypeMapperAnnotation != null) {
            return recipeTypeMapperAnnotation.requiredMods();
        }
        return null;
    }
}

