/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ACustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.CustomRecipeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class Utils {
    private static final Type CUSTOM_RECIPE_MAPPER_TYPE = Type.getType(CustomRecipeMapper.class);

    public static Map<? extends ACustomRecipeMapper<?>, String> getCustomRecipeMappers() {
        ModList modList = ModList.get();
        HashMap recipeTypeMappers = new HashMap();
        for (ModFileScanData scanData : modList.getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                ACustomRecipeMapper mapper;
                if (!CUSTOM_RECIPE_MAPPER_TYPE.equals((Object)data.getAnnotationType()) || !Utils.checkRequiredMod(data) || (mapper = Utils.createOrGetInstance(data.getMemberName(), ACustomRecipeMapper.class)) == null) continue;
                recipeTypeMappers.put(mapper, Utils.getAnnotationData(data, "value"));
                PEIntegration.LOGGER.info("Instantiated custom recipe mapper: {}", (Object)mapper.getName());
            }
        }
        return recipeTypeMappers;
    }

    public static <T> T createOrGetInstance(String className, Class<T> baseClass) {
        try {
            Class<T> subClass = Class.forName(className).asSubclass(baseClass);
            return subClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
            PEIntegration.LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            return null;
        }
    }

    public static boolean checkRequiredMod(ModFileScanData.AnnotationData data) {
        return Utils.checkRequiredMod(data, "value");
    }

    public static boolean checkRequiredMod(ModFileScanData.AnnotationData data, String key) {
        String modId = (String)Utils.getAnnotationData(data, key);
        if (modId != null && !ModList.get().isLoaded(modId)) {
            PEIntegration.debugLog("Skipped checking class {}, as its required mod ({}) is not loaded.", data.getMemberName(), modId);
            return false;
        }
        return true;
    }

    public static <T> T getAnnotationData(ModFileScanData.AnnotationData data, String key) {
        Map annotationData = data.getAnnotationData();
        if (annotationData.containsKey(key)) {
            try {
                return (T)annotationData.get(key);
            }
            catch (ClassCastException e) {
                PEIntegration.LOGGER.fatal("Annotation Data {}:{} was casted to an invalid class", (Object)key, annotationData.get(key), (Object)e);
            }
        }
        return null;
    }

    public static boolean convertFluidIngredient(int amount, List<FluidStack> fluidIngredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap, INSSFakeGroupManager fakeGroupManager, String recipeID) {
        if (fluidIngredient == null) {
            return false;
        }
        if (fluidIngredient.size() == 1) {
            return !Utils.addIngredient(ingredientMap, fluidIngredient.get(0));
        }
        if (fluidIngredient.size() > 0) {
            HashSet<NSSFluid> rawNSSMatches = new HashSet<NSSFluid>();
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (FluidStack match : fluidIngredient) {
                if (match.isEmpty()) continue;
                rawNSSMatches.add(NSSFluid.createFluid((FluidStack)match));
                fluids.add(match);
            }
            int count = fluids.size();
            if (count == 1) {
                return !Utils.addIngredient(ingredientMap, (FluidStack)fluids.get(0));
            }
            if (count > 1) {
                Tuple group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
                ingredientMap.addIngredient((Object)dummy, Math.max(amount, 1));
                if (((Boolean)group.func_76340_b()).booleanValue()) {
                    ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                    Iterator iterator = fluids.iterator();
                    while (iterator.hasNext()) {
                        IngredientMap groupIngredientMap = new IngredientMap();
                        FluidStack fluid = (FluidStack)iterator.next();
                        if (Utils.addIngredient((IngredientMap<NormalizedSimpleStack>)groupIngredientMap, fluid.copy())) {
                            return false;
                        }
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
        }
        return true;
    }

    public static boolean convertIngredient(int amount, Ingredient ingredient, IngredientMap<NormalizedSimpleStack> ingredientMap, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap, INSSFakeGroupManager fakeGroupManager, String recipeID) {
        ItemStack[] matches = Utils.getMatchingStacks(ingredient, recipeID);
        if (matches == null) {
            return false;
        }
        if (matches.length == 1) {
            return !Utils.addIngredient(ingredientMap, Utils.getStack(matches[0], amount), recipeID);
        }
        if (matches.length > 0) {
            HashSet<NSSItem> rawNSSMatches = new HashSet<NSSItem>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack match : matches) {
                if (match.func_190926_b()) continue;
                rawNSSMatches.add(NSSItem.createItem((ItemStack)match));
                stacks.add(match);
            }
            int count = stacks.size();
            if (count == 1) {
                return !Utils.addIngredient(ingredientMap, Utils.getStack((ItemStack)stacks.get(0), amount), recipeID);
            }
            if (count > 1) {
                Tuple group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
                ingredientMap.addIngredient((Object)dummy, Math.max(amount, 1));
                if (((Boolean)group.func_76340_b()).booleanValue()) {
                    ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                    Iterator iterator = stacks.iterator();
                    while (iterator.hasNext()) {
                        IngredientMap groupIngredientMap = new IngredientMap();
                        ItemStack stack = (ItemStack)iterator.next();
                        if (Utils.addIngredient((IngredientMap<NormalizedSimpleStack>)groupIngredientMap, stack.func_77946_l(), recipeID)) {
                            return false;
                        }
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
        }
        return true;
    }

    public static boolean addIngredient(IngredientMap<NormalizedSimpleStack> ingredientMap, ItemStack stack, String recipeID) {
        Item item = stack.func_77973_b();
        boolean hasContainerItem = false;
        try {
            hasContainerItem = item.hasContainerItem(stack);
            if (hasContainerItem) {
                ingredientMap.addIngredient((Object)NSSItem.createItem((ItemStack)item.getContainerItem(stack)), -1);
            }
        }
        catch (Exception e) {
            ResourceLocation itemName = item.getRegistryName();
            if (hasContainerItem) {
                if (Utils.isTagException(e)) {
                    PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.func_110624_b(), (Object)e);
                } else {
                    PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item based on the stack in the recipe. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.func_110624_b(), (Object)e);
                }
            } else if (Utils.isTagException(e)) {
                PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack has a container item, due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.func_110624_b(), (Object)e);
            } else {
                PEIntegration.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack in the recipe has a container item. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.func_110624_b(), (Object)e);
            }
            return true;
        }
        ingredientMap.addIngredient((Object)NSSItem.createItem((ItemStack)stack), stack.func_190916_E());
        return false;
    }

    public static boolean addIngredient(IngredientMap<NormalizedSimpleStack> ingredientMap, FluidStack stack) {
        ingredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
        return true;
    }

    public static boolean isTagException(Exception e) {
        return e instanceof IllegalStateException && e.getMessage().matches("Tag \\S*:\\S* used before it was bound");
    }

    public static NSSOutput mapOutputs(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, String recipeID, Object ... allOutputs) {
        List<Object> outputs = Arrays.asList(allOutputs);
        if (allOutputs.length == 1 && allOutputs[0] instanceof Collection) {
            outputs = new ArrayList<Object>((Collection)allOutputs[0]);
        }
        HashMap<Object, Integer> outputStacks = new HashMap<Object, Integer>(outputs.size());
        int totalOutputs = 0;
        for (Object output : outputs) {
            if (output == null) continue;
            if (output instanceof ItemStack) {
                ItemStack item = (ItemStack)output;
                if (item.func_190926_b()) continue;
                outputStacks.put(NSSItem.createItem((ItemStack)item), item.func_190916_E());
                totalOutputs += item.func_190916_E();
                continue;
            }
            if (output instanceof FluidStack) {
                FluidStack fluid = (FluidStack)output;
                if (fluid.isEmpty()) continue;
                outputStacks.put(NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                totalOutputs += fluid.getAmount();
                continue;
            }
            PEIntegration.LOGGER.warn("Recipe ({}) has unsupported output: {}. Skipping...", (Object)recipeID, output);
        }
        NormalizedSimpleStack dummy = (NormalizedSimpleStack)fakeGroupManager.getOrCreateFakeGroup(outputStacks.keySet()).func_76341_a();
        for (Map.Entry entry : outputStacks.entrySet()) {
            mapper.addConversion(((Integer)entry.getValue()).intValue(), entry.getKey(), Utils.getDummyMap(dummy, (Integer)entry.getValue()));
        }
        return new NSSOutput(totalOutputs, dummy);
    }

    public static NSSOutput mapOutput(IMappingCollector<NormalizedSimpleStack, Long> mapper, INSSFakeGroupManager fakeGroupManager, String recipeID, Object ... outputVariants) {
        List<Object> outputs = Arrays.asList(outputVariants);
        if (outputVariants.length == 1 && outputVariants[0] instanceof Collection) {
            outputs = new ArrayList<Object>((Collection)outputVariants[0]);
        }
        HashMap<Object, Integer> outputStacks = new HashMap<Object, Integer>(outputs.size());
        for (Object output : outputs) {
            if (output == null) continue;
            if (output instanceof ItemStack) {
                ItemStack item = (ItemStack)output;
                if (item.func_190926_b()) continue;
                outputStacks.put(NSSItem.createItem((ItemStack)item), item.func_190916_E());
                continue;
            }
            if (output instanceof FluidStack) {
                FluidStack fluid = (FluidStack)output;
                if (fluid.isEmpty()) continue;
                outputStacks.put(NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
                continue;
            }
            PEIntegration.LOGGER.warn("Recipe ({}) has unsupported output: {}. Skipping...", (Object)recipeID, output);
        }
        NormalizedSimpleStack dummy = (NormalizedSimpleStack)fakeGroupManager.getOrCreateFakeGroup(outputStacks.keySet()).func_76341_a();
        for (Map.Entry entry : outputStacks.entrySet()) {
            mapper.addConversion(((Integer)entry.getValue()).intValue(), entry.getKey(), Utils.getDummyMap(dummy, 1));
        }
        return new NSSOutput(1, dummy);
    }

    public static ItemStack[] getMatchingStacks(Ingredient ingredient, String recipeID) {
        try {
            return ingredient.func_193365_a();
        }
        catch (Exception e) {
            PEIntegration.LOGGER.fatal("Failed to map recipe ({}). Ingredient ({}) failed to get matching stacks", (Object)recipeID, (Object)ingredient.getClass().getName(), (Object)e);
            return null;
        }
    }

    public static ItemStack getStack(ItemStack item, int amount) {
        if (amount > 0) {
            return new ItemStack((IItemProvider)item.func_77973_b(), amount);
        }
        return item.func_77946_l();
    }

    public static Map<NormalizedSimpleStack, Integer> getDummyMap(NormalizedSimpleStack dummy) {
        return Utils.getDummyMap(dummy, 1);
    }

    public static Map<NormalizedSimpleStack, Integer> getDummyMap(NormalizedSimpleStack dummy, int amount) {
        IngredientMap ingredientMap = new IngredientMap();
        ingredientMap.addIngredient((Object)dummy, amount);
        return ingredientMap.getMap();
    }
}

