/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import ipsis.woot.crafting.AnvilRecipe;
import ipsis.woot.crafting.FluidConvertorRecipe;
import ipsis.woot.crafting.InfuserRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class WootAddon {
    public static final String MODID = "woot";
    public static final NormalizedSimpleStack WHITE_STACK = NSSFake.create((String)"woot_white_dye_stack");
    public static final NormalizedSimpleStack RED_STACK = NSSFake.create((String)"woot_red_dye_stack");
    public static final NormalizedSimpleStack YELLOW_STACK = NSSFake.create((String)"woot_yellow_dye_stack");
    public static final NormalizedSimpleStack BLUE_STACK = NSSFake.create((String)"woot_blue_dye_stack");

    @RecipeTypeMapper(requiredMods={"woot"}, priority=1)
    public static class WootInfuserMapper
    extends ARecipeTypeMapper<InfuserRecipe> {
        @Override
        public String getName() {
            return "WootInfuserMapper";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == InfuserRecipe.INFUSER_TYPE;
        }

        @Override
        public NSSInput getInput(InfuserRecipe recipe) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(1);
            ingredients.add(recipe.getIngredient());
            if (recipe.getAugment() != null) {
                ingredients.add(recipe.getAugment());
            }
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            if (recipe.getFluidInput() != null) {
                FluidStack fluid = recipe.getFluidInput();
                ingredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)fluid), fluid.getAmount());
            }
            for (Ingredient ingredient : ingredients) {
                if (this.convertIngredient(ingredient, (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(InfuserRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"woot"}, priority=1)
    public static class WootFluidConvertorMapper
    extends ARecipeTypeMapper<FluidConvertorRecipe> {
        @Override
        public String getName() {
            return "WootFluidConvertorMapper";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == FluidConvertorRecipe.FLUID_CONV_TYPE;
        }

        @Override
        public NSSOutput getOutput(FluidConvertorRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }

        @Override
        public NSSInput getInput(FluidConvertorRecipe recipe) {
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            if (!this.convertIngredient(recipe.getCatalyst(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            ingredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)recipe.getInputFluid()), recipe.getInputFluid().getAmount());
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"woot"}, priority=1)
    public static class WootAnvilMapper
    extends ARecipeTypeMapper<AnvilRecipe> {
        @Override
        public String getName() {
            return "WootAnvilMapper";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AnvilRecipe.ANVIL_TYPE;
        }

        @Override
        public NSSOutput getOutput(AnvilRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }

        @Override
        public List<Ingredient> getIngredients(AnvilRecipe recipe) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
            ingredients.add(recipe.getBaseIngredient());
            return ingredients;
        }
    }
}

