/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.Tuple;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;

public class TinkersConstructAddon {
    public static final String MODID = "tconstruct";

    static String NAME(String name) {
        return "TinkersConstruct" + name + "Mapper";
    }

    @ConversionProvider(value="tconstruct")
    public static class TCDataGenerator
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for Tinkers Construct").before(TCDataGenerator.ingotTag("cobalt"), 4096L);
        }
    }

    @RecipeTypeMapper(requiredMods={"tconstruct"}, priority=1)
    public static class TCMeltingMapper
    extends ARecipeTypeMapper<IMeltingRecipe> {
        @Override
        public String getName() {
            return TinkersConstructAddon.NAME("Melting");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypes.MELTING;
        }

        @Override
        public NSSOutput getOutput(IMeltingRecipe recipe) {
            if (recipe instanceof MeltingRecipe) {
                return this.mapOutput(((MeltingRecipe)recipe).getDisplayOutput());
            }
            return NSSOutput.EMPTY;
        }
    }

    @RecipeTypeMapper(requiredMods={"tconstruct"}, priority=1)
    public static class TCCastingMapper
    extends ARecipeTypeMapper<ICastingRecipe> {
        @Override
        public String getName() {
            return TinkersConstructAddon.NAME("Casting");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypes.CASTING_BASIN || iRecipeType == RecipeTypes.CASTING_TABLE;
        }

        @Override
        public boolean convertRecipe(ICastingRecipe recipe) {
            if (recipe instanceof ItemCastingRecipe) {
                return this.convertItemCastingRecipe((ItemCastingRecipe)recipe);
            }
            PEIntegration.LOGGER.warn("Unsupported Tinkers Casting recipe ({}), currently only ItemCastingRecipe.", (Object)recipe);
            return false;
        }

        private boolean convertItemCastingRecipe(ItemCastingRecipe recipe) {
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b()) {
                PEIntegration.debugLog("Recipe ({}) contains no outputs: {}", this.recipeID, recipe);
                return false;
            }
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            if (recipe.hasCast() && recipe.isConsumed() && !this.convertIngredient(recipe.getCast(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return this.addConversionsAndReturn(fakeGroupMap, false);
            }
            if (!this.convertFluidIngredient(recipe.getFluids(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) {
                return this.addConversionsAndReturn(fakeGroupMap, false);
            }
            this.mapper.addConversion(output.func_190916_E(), (Object)NSSItem.createItem((ItemStack)output), ingredientMap.getMap());
            return this.addConversionsAndReturn(fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"tconstruct"}, priority=1)
    public static class TCAlloyingMapper
    extends ARecipeTypeMapper<AlloyRecipe> {
        @Override
        public String getName() {
            return TinkersConstructAddon.NAME("Alloying");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypes.ALLOYING;
        }

        @Override
        public NSSInput getInput(AlloyRecipe recipe) {
            return this.convertFluidIngredients(recipe.getDisplayInputs());
        }

        @Override
        public NSSOutput getOutput(AlloyRecipe recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }
}

