/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.ma.api.recipes.IItemAndPatternRecipe;
import com.ma.api.rituals.IRitualReagent;
import com.ma.items.ItemInit;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.arcanefurnace.ArcaneFurnaceRecipe;
import com.ma.recipes.eldrin.EldrinAltarRecipe;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import com.ma.recipes.rituals.RitualRecipe;
import com.ma.recipes.runeforging.RuneforgingRecipe;
import com.ma.recipes.runeforging.RunescribingRecipe;
import com.ma.tools.MATags;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class ManaAndArtificeAddon {
    public static final String MODID = "manaandartifice";

    public static String NAME(String name) {
        return "ManaAndArtifice" + name + "Mapper";
    }

    public static abstract class MAAItemAndPatternRecipeMapper<R extends IItemAndPatternRecipe & IRecipe<?>>
    extends ARecipeTypeMapper<R> {
        @Override
        protected List<Ingredient> getIngredients(R recipe) {
            ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
            for (ResourceLocation resourceLocation : recipe.getRequiredItems()) {
                recipeIngredients.add(Ingredient.func_234819_a_(MATags.smartLookupItem((ResourceLocation)resourceLocation).stream().map(item -> {
                    ItemStack stack = new ItemStack((IItemProvider)item);
                    if (stack.func_77973_b() == Items.field_151068_bn && stack.func_77978_p() == null) {
                        PotionUtils.func_185188_a((ItemStack)stack, (Potion)Potions.field_185230_b);
                    }
                    return stack;
                })));
            }
            return recipeIngredients;
        }
    }

    @ConversionProvider(value="manaandartifice")
    public static class MAAConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for Mana and Artifice").before((IItemProvider)ItemInit.VINTEUM_DUST.get(), 32L);
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAARuneforgingRecipeMapper
    extends ARecipeTypeMapper<RuneforgingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Runeforging");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RUNEFORGING_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(RuneforgingRecipe recipe) {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            inputs.add(Ingredient.func_234819_a_(MATags.smartLookupItem((ResourceLocation)recipe.getMaterial()).stream().map(ItemStack::new)));
            inputs.add(Ingredient.func_234819_a_(MATags.smartLookupItem((ResourceLocation)recipe.getPatternResource()).stream().map(ItemStack::new)));
            return inputs;
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAARunescribingRecipeMapper
    extends ARecipeTypeMapper<RunescribingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Runescribing");
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RUNESCRIBING_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAARitualRecipeMapper
    extends ARecipeTypeMapper<RitualRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Ritual");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + "NOTE: Disabled by default because this really shouldn't be here.";
        }

        public boolean isAvailable() {
            return false;
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.RITUAL_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(RitualRecipe recipe) {
            IRitualReagent[][] reagents;
            ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
            for (IRitualReagent[] reagent : reagents = recipe.getReagents()) {
                for (int j = 0; j < reagent.length; ++j) {
                    if (reagent[j] == null || reagent[j].isEmpty() || reagent[j].isDynamic()) continue;
                    recipeIngredients.add(Ingredient.func_234819_a_(MATags.smartLookupItem((ResourceLocation)reagent[j].getResourceLocation()).stream().map(ItemStack::new)));
                }
            }
            return recipeIngredients;
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAAManaweavingRecipeMapper
    extends MAAItemAndPatternRecipeMapper<ManaweavingRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("Manaweaving");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.MANAWEAVING_RECIPE_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAAEldrinAltarRecipeMapper
    extends MAAItemAndPatternRecipeMapper<EldrinAltarRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("EldrinAltar");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.ELDRIN_ALTAR_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"manaandartifice"}, priority=1)
    public static class MAAArcaneFurnaceRecipeMapper
    extends ARecipeTypeMapper<ArcaneFurnaceRecipe> {
        @Override
        public String getName() {
            return ManaAndArtificeAddon.NAME("ArcaneFurnace");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeInit.ARCANE_FURNACE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(ArcaneFurnaceRecipe recipe) {
            return Collections.singletonList(Ingredient.func_234819_a_(MATags.smartLookupItem((ResourceLocation)recipe.getInputItem()).stream().map(ItemStack::new)));
        }
    }
}

