/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import com.tagnumelite.projecteintegration.api.Utils;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class ImmersiveEngineeringAddon {
    public static final String MODID = "immersiveengineering";

    protected static String NAME(String name) {
        return "ImmersiveEngineering" + name + "Mapper";
    }

    @ConversionProvider(value="immersiveengineering")
    public static class IEConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("default conversions for immersive engineering").before(IEConversionProvider.forgeTag("fiber_hemp"), 4L).before(IEConversionProvider.dustTag("wood"), 1L).before(IEConversionProvider.dustTag("sulfur"), 8L).before(IEConversionProvider.dustTag("nitrate"), 8L);
            for (Block block : IEBlocks.WoodenDecoration.treatedWood.values()) {
                ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.conversion((IItemProvider)block)).ingredient((ITag)ItemTags.field_199905_b, 8)).end();
            }
        }
    }

    public static class IESqueezerMapper
    extends ARecipeTypeMapper<SqueezerRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Squeezer");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == SqueezerRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(SqueezerRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(SqueezerRecipe recipe) {
            return this.mapOutputs(recipe.itemOutput, recipe.fluidOutput);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IESawmillMapper
    extends ARecipeTypeMapper<SawmillRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Sawmill");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == SawmillRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(SawmillRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }

        @Override
        public NSSOutput getOutput(SawmillRecipe recipe) {
            return new NSSOutput(recipe.output.func_77946_l());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEMixerMapper
    extends ARecipeTypeMapper<MixerRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Mixer");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return false;
        }

        @Override
        public NSSOutput getOutput(MixerRecipe recipe) {
            return new NSSOutput(recipe.fluidOutput.copy());
        }

        @Override
        public NSSInput getInput(MixerRecipe recipe) {
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            for (IngredientWithSize input : recipe.itemInputs) {
                this.convertIngredient(input.getCount(), input.getBaseIngredient(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            }
            return super.getInput(recipe);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEMetalPressMapper
    extends ARecipeTypeMapper<MetalPressRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("MetalPress");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == MetalPressRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(MetalPressRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(MetalPressRecipe recipe) {
            return new NSSOutput(recipe.output.func_77946_l());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IECrusherMapper
    extends ARecipeTypeMapper<CrusherRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Crusher");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == CrusherRecipe.TYPE;
        }

        @Override
        public NSSOutput getOutput(CrusherRecipe recipe) {
            return new NSSOutput(recipe.output.func_77946_l());
        }

        @Override
        protected List<Ingredient> getIngredients(CrusherRecipe recipe) {
            return Collections.singletonList(recipe.input);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IECokeOvenMapper
    extends ARecipeTypeMapper<CokeOvenRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("CokeOven");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == CokeOvenRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(CokeOvenRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(CokeOvenRecipe recipe) {
            if (recipe.creosoteOutput > 0) {
                ItemStack itemOutput = recipe.func_77571_b().func_77946_l();
                FluidStack creosoteOutput = new FluidStack((Fluid)IEContent.fluidCreosote, recipe.creosoteOutput);
                NSSItem itemStack = NSSItem.createItem((ItemStack)itemOutput);
                NSSFluid fluidStack = NSSFluid.createFluid((FluidStack)creosoteOutput);
                Tuple<NormalizedSimpleStack, Boolean> group = this.getFakeGroup(new NormalizedSimpleStack[]{fluidStack, itemStack});
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
                Map<NormalizedSimpleStack, Integer> dummyMap = Utils.getDummyMap(dummy);
                this.mapper.addConversion(creosoteOutput.getAmount(), (Object)fluidStack, dummyMap);
                this.mapper.addConversion(itemOutput.func_190916_E(), (Object)itemStack, dummyMap);
                return new NSSOutput(2, dummy);
            }
            return new NSSOutput(recipe.func_77571_b());
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEBlastFurnaceMapper
    extends ARecipeTypeMapper<BlastFurnaceRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("BlastFurnace");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BlastFurnaceRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(BlastFurnaceRecipe recipe) {
            return Collections.singletonList(recipe.input.getBaseIngredient());
        }

        @Override
        public NSSOutput getOutput(BlastFurnaceRecipe recipe) {
            ItemStack itemOutput = recipe.func_77571_b().func_77946_l();
            ItemStack slagOutput = recipe.slag.func_77946_l();
            NSSItem itemStack = NSSItem.createItem((ItemStack)itemOutput);
            NSSItem slagStack = NSSItem.createItem((ItemStack)slagOutput);
            Tuple<NormalizedSimpleStack, Boolean> group = this.getFakeGroup(new NormalizedSimpleStack[]{itemStack, slagStack});
            NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
            Map<NormalizedSimpleStack, Integer> dummyMap = Utils.getDummyMap(dummy);
            this.mapper.addConversion(slagOutput.func_190916_E(), (Object)slagStack, dummyMap);
            this.mapper.addConversion(itemOutput.func_190916_E(), (Object)itemStack, dummyMap);
            return new NSSOutput(2, dummy);
        }
    }

    public static class IEArcFurnaceMapper
    extends ARecipeTypeMapper<ArcFurnaceRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("ArcFurnace");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ArcFurnaceRecipe.TYPE;
        }

        @Override
        public NSSOutput getOutput(ArcFurnaceRecipe recipe) {
            return super.getOutput(recipe);
        }
    }

    @RecipeTypeMapper(requiredMods={"immersiveengineering"}, priority=1)
    public static class IEAlloyMapper
    extends ARecipeTypeMapper<AlloyRecipe> {
        @Override
        public String getName() {
            return ImmersiveEngineeringAddon.NAME("Alloy");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AlloyRecipe.TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(AlloyRecipe recipe) {
            return Arrays.asList(recipe.input0.getBaseIngredient(), recipe.input1.getBaseIngredient());
        }
    }
}

