/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.google.common.collect.Lists;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class FTBIndustrialContraptionsAddon {
    public static final String MODID = "ftbic";

    public static String NAME(String name) {
        return "FTBIndustrialContraptions" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICExtrudingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Extruding");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.EXTRUDING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICRollingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Rolling");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.ROLLING.get()).recipeType;
        }
    }

    public static class FTBICCanningMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Canning");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.CANNING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICReprocessingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Reprocessing");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.REPROCESSING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICCompressingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Compressing");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.COMPRESSING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICSeparatingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Separating");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.SEPARATING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICMaceratingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Macerating");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.MACERATING.get()).recipeType;
        }
    }

    @RecipeTypeMapper(requiredMods={"ftbic"}, priority=1)
    public static class FTBICSmeltingMapper
    extends AFTBMachineRecipeMapper {
        @Override
        public String getName() {
            return FTBIndustrialContraptionsAddon.NAME("Smelting");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == ((MachineRecipeSerializer)FTBICRecipes.SMELTING.get()).recipeType;
        }
    }

    public static abstract class AFTBMachineRecipeMapper
    extends ARecipeTypeMapper<MachineRecipe> {
        @Override
        public NSSOutput getOutput(MachineRecipe recipe) {
            List outputItems = recipe.outputItems.stream().filter(s -> s.chance >= 1.0).map(s -> s.stack).collect(Collectors.toList());
            ArrayList outputs = Lists.newArrayList();
            outputs.addAll(recipe.outputFluids);
            outputs.addAll(outputItems);
            return this.mapOutputs(outputs.toArray());
        }

        @Override
        public NSSInput getInput(MachineRecipe recipe) {
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            for (IngredientWithCount ingredient : recipe.inputItems) {
                if (this.convertIngredient(ingredient.count, ingredient.ingredient, (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            for (FluidStack fluidInput : recipe.inputFluids) {
                if (this.convertFluidIngredient(Collections.singletonList(fluidInput), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }
}

