/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.api.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;

public class ExNihiloSequentiaAddon {
    public static final String MODID = "exnihilosequentia";

    static String NAME(String name) {
        return "ExNihiloSequentia" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSSieveMapper
    extends ARecipeTypeMapper<SieveRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Sieve");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Only maps guaranteed drop, ignore chanced items.";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == SieveRecipe.RECIPE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(SieveRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(SieveRecipe recipe) {
            return new NSSOutput(recipe.getDrop());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSHammerMapper
    extends ARecipeTypeMapper<HammerRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Hammer");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == HammerRecipe.RECIPE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(HammerRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(HammerRecipe recipe) {
            Object[] outputs = recipe.getOutput().stream().filter(output -> output.getChance() >= 1.0f).map(ItemStackWithChance::getStack).toArray();
            if (outputs.length == 0) {
                PEIntegration.debugLog("Recipe ({}) contains no guaranteed outputs", this.recipeID);
                return NSSOutput.EMPTY;
            }
            return this.mapOutputs(outputs);
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSFluidTransformationMapper
    extends ARecipeTypeMapper<FluidTransformRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("FluidTransformation");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == FluidTransformRecipe.RECIPE_TYPE;
        }

        @Override
        public NSSInput getInput(FluidTransformRecipe recipe) {
            return NSSInput.createFluid(recipe.getFluidInTank());
        }

        @Override
        public NSSOutput getOutput(FluidTransformRecipe recipe) {
            return new NSSOutput(recipe.getResult());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSFluidOnTopMapper
    extends ARecipeTypeMapper<FluidOnTopRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("FluidOnTop");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == FluidOnTopRecipe.RECIPE_TYPE;
        }

        @Override
        public NSSInput getInput(FluidOnTopRecipe recipe) {
            return NSSInput.createFluid(recipe.getFluidInTank());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSFluidItemTransformationMapper
    extends ARecipeTypeMapper<FluidItemRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("FluidItemTransformation");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == FluidItemRecipe.RECIPE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(FluidItemRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }
    }

    @RecipeTypeMapper(requiredMods={"exnihilosequentia"}, priority=1)
    public static class ENSCrucibleMapper
    extends ARecipeTypeMapper<CrucibleRecipe> {
        @Override
        public String getName() {
            return ExNihiloSequentiaAddon.NAME("Crucible");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == CrucibleRecipe.RECIPE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(CrucibleRecipe recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(CrucibleRecipe recipe) {
            return new NSSOutput(recipe.getAmount(), (NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)recipe.getResultFluid()));
        }
    }
}

