/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.init.DETags;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ObjectHolder;

public class DraconicEvolutionAddon {
    public static final String MODID = "draconicevolution";

    @ObjectHolder(value="draconicevolution")
    @ConversionProvider(value="draconicevolution")
    public static class DEConversionProvider
    extends AConversionProvider {
        @ObjectHolder(value="dragon_heart")
        public static final Item DRAGON_HEART = null;
        @ObjectHolder(value="chaos_shard")
        public static final Item CHAOS_SHARD = null;

        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Sets default conversions for Draconic Evolution").before((ITag)DETags.Items.DUSTS_DRACONIUM, 2048L).before((IItemProvider)DRAGON_HEART, 262144L).before((IItemProvider)CHAOS_SHARD, 4096000L);
        }
    }

    @RecipeTypeMapper(requiredMods={"draconicevolution"}, priority=1)
    public static class DEFusionMapper
    extends ARecipeTypeMapper<FusionRecipe> {
        @Override
        public String getName() {
            return "DraconicEvolutionFusionMapper";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == DraconicAPI.FUSION_RECIPE_TYPE;
        }

        @Override
        protected List<Ingredient> getIngredients(FusionRecipe recipe) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.add(recipe.getCatalyst());
            ingredients.addAll(recipe.fusionIngredients().stream().filter(IFusionRecipe.IFusionIngredient::consume).map(IFusionRecipe.IFusionIngredient::get).collect(Collectors.toList()));
            return ingredients;
        }
    }
}

