/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.content.contraptions.components.millstone.MillingRecipe;
import com.simibubi.create.content.contraptions.components.mixer.CompactingRecipe;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class CreateAddon {
    public static final String MODID = "create";

    static String NAME(String name) {
        return "Create" + name + "Mapper";
    }

    @ConversionProvider(value="create")
    public static class CDataGenerator
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("default conversions for create").before((IItemProvider)AllItems.BAR_OF_CHOCOLATE.get(), 32L);
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateSandPaperPolishingMapper
    extends CreateProcessingRecipeMapper<SandPaperPolishingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("SandpaperPolishing");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.SANDPAPER_POLISHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateDeployerApplicationMapper
    extends CreateProcessingRecipeMapper<DeployerApplicationRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("DeployerApplication");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.DEPLOYING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateSplashingMapper
    extends CreateProcessingRecipeMapper<SplashingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Splashing");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.SPLASHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreatePressingMapper
    extends CreateProcessingRecipeMapper<PressingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Pressing");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.PRESSING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateMixingMapper
    extends CreateProcessingRecipeMapper<MixingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("CUTTING");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.MIXING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateMillingMapper
    extends CreateProcessingRecipeMapper<MillingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Milling");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.MILLING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCuttingMapper
    extends CreateProcessingRecipeMapper<CuttingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Cutting");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.CUTTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCrushingMapper
    extends CreateProcessingRecipeMapper<CrushingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Crushing");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.CRUSHING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateCompactingMapper
    extends CreateProcessingRecipeMapper<CompactingRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("Compacting");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.COMPACTING.getType();
        }
    }

    @RecipeTypeMapper(requiredMods={"create"}, priority=1)
    public static class CreateBasinMapper
    extends CreateProcessingRecipeMapper<BasinRecipe> {
        @Override
        public String getName() {
            return CreateAddon.NAME("BASIN");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == AllRecipeTypes.BASIN.getType();
        }
    }

    private static abstract class CreateProcessingRecipeMapper<R extends ProcessingRecipe<?>>
    extends ARecipeTypeMapper<R> {
        private CreateProcessingRecipeMapper() {
        }

        @Override
        public NSSInput getInput(R recipe) {
            NonNullList ingredients = recipe.func_192400_c();
            NonNullList fluidIngredients = recipe.getFluidIngredients();
            if (ingredients.isEmpty() && fluidIngredients.isEmpty()) {
                PEIntegration.debugLog("Recipe ({}) contains no inputs: (Ingredients: {}; Fluids: {})", this.recipeID, ingredients, fluidIngredients);
                return null;
            }
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            IngredientMap ingredientMap = new IngredientMap();
            for (Ingredient ingredient : ingredients) {
                if (this.convertIngredient(ingredient, (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap)) continue;
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, false);
            }
            for (FluidIngredient fluidIngredient : fluidIngredients) {
                int amount = fluidIngredient.getRequiredAmount();
                List matches = fluidIngredient.getMatchingFluidStacks();
                if (matches.isEmpty()) continue;
                if (matches.size() == 1) {
                    ingredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)((FluidStack)matches.get(0))), amount);
                    continue;
                }
                HashSet<NSSFluid> rawNSSMatches = new HashSet<NSSFluid>();
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (FluidStack match : matches) {
                    if (match.isEmpty()) continue;
                    rawNSSMatches.add(NSSFluid.createFluid((FluidStack)match));
                    stacks.add(match);
                }
                int count = stacks.size();
                if (count == 1) {
                    ingredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)((FluidStack)stacks.get(0))), amount);
                    continue;
                }
                if (count <= 1) continue;
                Tuple group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
                ingredientMap.addIngredient((Object)dummy, Math.max(amount, 1));
                if (!((Boolean)group.func_76340_b()).booleanValue()) continue;
                ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                for (FluidStack stack : stacks) {
                    IngredientMap groupIngredientMap = new IngredientMap();
                    groupIngredientMap.addIngredient((Object)NSSFluid.createFluid((FluidStack)stack), 1);
                    groupIngredientMaps.add(groupIngredientMap);
                }
                fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(R recipe) {
            ArrayList outputs = new ArrayList();
            List results = recipe.getRollableResults().stream().filter(pO -> pO.getChance() >= 1.0f).map(ProcessingOutput::getStack).collect(Collectors.toList());
            outputs.addAll(results);
            outputs.addAll(recipe.getFluidResults());
            if (outputs.size() == 0) {
                return NSSOutput.EMPTY;
            }
            return this.mapOutputs(outputs.toArray());
        }
    }
}

