/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import dev.compactmods.crafting.Registration;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import dev.compactmods.crafting.recipes.components.BlockComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;

public class CompactCraftingAddon {

    @RecipeTypeMapper(requiredMods={"compactcrafting"}, priority=1)
    public static class CCMiniaturizationMapper
    extends ARecipeTypeMapper<MiniaturizationRecipe> {
        @Override
        public String getName() {
            return "CompactCraftingMiniaturizationMapper";
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == Registration.MINIATURIZATION_RECIPE_TYPE;
        }

        @Override
        public boolean convertRecipe(MiniaturizationRecipe recipe) {
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            List<ItemStack> catalysts = recipe.getCatalyst() != null && !recipe.getCatalyst().matches(ItemStack.field_190927_a) ? new ArrayList<ItemStack>(recipe.getCatalyst().getPossible()) : Collections.singletonList(new ItemStack((IItemProvider)Items.field_151137_ax));
            this.convertIngredient(1, Ingredient.func_234819_a_(catalysts.stream()), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            for (Map.Entry entry : recipe.getComponentTotals().entrySet()) {
                BlockComponent blockComponent;
                Item blockItem;
                IRecipeBlockComponent iBlockComponent;
                Optional component;
                ItemStack[] componentKey = (ItemStack[])entry.getKey();
                int componentAmount = (Integer)entry.getValue();
                if (componentAmount <= 0 || !(component = recipe.getComponents().getBlock((String)componentKey)).isPresent() || !((iBlockComponent = (IRecipeBlockComponent)component.get()) instanceof BlockComponent) || (blockItem = (blockComponent = (BlockComponent)iBlockComponent).getBlock().func_199767_j()) == Items.field_190931_a) continue;
                ingredientMap.addIngredient((Object)NSSItem.createItem((ItemStack)new ItemStack((IItemProvider)blockItem)), componentAmount);
            }
            ItemStack[] outputs = recipe.getOutputs();
            if (outputs.length == 0) {
                return false;
            }
            if (outputs.length == 1) {
                ItemStack output = outputs[0];
                this.mapper.addConversion(output.func_190916_E(), (Object)NSSItem.createItem((ItemStack)output), ingredientMap.getMap());
                return true;
            }
            HashSet<NSSItem> rawNSSMatches = new HashSet<NSSItem>();
            for (ItemStack output : outputs) {
                if (output.func_190926_b()) continue;
                rawNSSMatches.add(NSSItem.createItem((ItemStack)output));
            }
            Tuple group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
            NormalizedSimpleStack nssFake = (NormalizedSimpleStack)group.func_76341_a();
            IngredientMap outputInputIng = new IngredientMap();
            outputInputIng.addIngredient((Object)nssFake, 1);
            Map outputInputMap = outputInputIng.getMap();
            for (ItemStack output : outputs) {
                this.mapper.addConversion(output.func_190916_E(), (Object)NSSItem.createItem((ItemStack)output), outputInputMap);
            }
            this.mapper.addConversion(outputs.length, (Object)nssFake, ingredientMap.getMap());
            return true;
        }
    }
}

