/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;

public class BotaniaAddon {
    public static final String MODID = "botania";

    static String NAME(String name) {
        return "Botania" + name + "Mapper";
    }

    @ConversionProvider(value="botania")
    public static class BotaniaConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for Botania").before((IItemProvider)ModItems.pebble, 1L).before((IItemProvider)ModItems.livingroot, 1L).before((IItemProvider)ModItems.lifeEssence, 256L).before((IItemProvider)ModItems.enderAirBottle, 1024L);
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BTerraPlateMapper
    extends ARecipeTypeMapper<ITerraPlateRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("TerraPlate");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.TERRA_PLATE_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BRuneAlterMapper
    extends ARecipeTypeMapper<IRuneAltarRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("RuneAlter");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.RUNE_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BPureDaisyMapper
    extends ARecipeTypeMapper<IPureDaisyRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("PureDaisy");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.PURE_DAISY_TYPE;
        }

        @Override
        public NSSOutput getOutput(IPureDaisyRecipe recipe) {
            return new NSSOutput(recipe.getOutputState());
        }

        @Override
        public NSSInput getInput(IPureDaisyRecipe recipe) {
            List matches = recipe.getInput().getDisplayed();
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            if (matches == null) {
                return null;
            }
            if (matches.size() == 1) {
                ingredientMap.addIngredient((Object)NSSItem.createItem((IItemProvider)((BlockState)matches.get(0)).func_177230_c()), 1);
                return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
            }
            if (matches.size() > 1) {
                HashSet<NSSItem> rawNSSMatches = new HashSet<NSSItem>();
                ArrayList<Block> stacks = new ArrayList<Block>();
                for (BlockState match : matches) {
                    rawNSSMatches.add(NSSItem.createItem((IItemProvider)match.func_177230_c()));
                    stacks.add(match.func_177230_c());
                }
                int count = stacks.size();
                if (count == 1) {
                    ingredientMap.addIngredient((Object)NSSItem.createItem((IItemProvider)((Block)stacks.get(0)).getBlock()), 1);
                    return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
                }
                Tuple group = this.fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
                NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.func_76341_a();
                ingredientMap.addIngredient((Object)dummy, 1);
                if (((Boolean)group.func_76340_b()).booleanValue()) {
                    ArrayList<IngredientMap> groupIngredientMaps = new ArrayList<IngredientMap>();
                    for (Block stack : stacks) {
                        IngredientMap groupIngredientMap = new IngredientMap();
                        groupIngredientMap.addIngredient((Object)NSSItem.createItem((IItemProvider)stack), 1);
                        groupIngredientMaps.add(groupIngredientMap);
                    }
                    fakeGroupMap.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
                }
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BPetalMapper
    extends ARecipeTypeMapper<IPetalRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("Petal");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.PETAL_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BManaInfusionMapper
    extends ARecipeTypeMapper<IManaInfusionRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("ManaInfusion");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.MANA_INFUSION_TYPE;
        }
    }

    @RecipeTypeMapper(requiredMods={"botania"}, priority=1)
    public static class BElvenTradeMapper
    extends ARecipeTypeMapper<IElvenTradeRecipe> {
        @Override
        public String getName() {
            return BotaniaAddon.NAME("ElvenTrade");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == ModRecipeTypes.ELVEN_TRADE_TYPE;
        }

        @Override
        public NSSOutput getOutput(IElvenTradeRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }
}

