/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.FRandom;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;

public class BloodMagicAddon {
    public static final String MODID = "bloodmagic";

    static String NAME(String name) {
        return "BloodMagic" + name + "Mapper";
    }

    @ConversionProvider(value="bloodmagic")
    public static class BloodMagicConversion
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("default recipe conversions for Blood Magic").before((IItemProvider)BloodMagicItems.WEAK_BLOOD_SHARD.get(), 256L).before(BloodMagicConversion.tag("bloodmagic:crystals/demon"), 512L);
        }
    }

    @RecipeTypeMapper(requiredMods={"bloodmagic"}, priority=1)
    public static class BMTartaricForgeMapper
    extends ARecipeTypeMapper<RecipeTartaricForge> {
        @Override
        public String getName() {
            return BloodMagicAddon.NAME("TartaricForge");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BloodMagicRecipeType.TARTARICFORGE;
        }

        @Override
        public NSSOutput getOutput(RecipeTartaricForge recipe) {
            return new NSSOutput(recipe.getOutput());
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeTartaricForge recipe) {
            return recipe.getInput();
        }
    }

    @RecipeTypeMapper(requiredMods={"bloodmagic"}, priority=1)
    public static class BMBloodAltarMapper
    extends ARecipeTypeMapper<RecipeBloodAltar> {
        @Override
        public String getName() {
            return BloodMagicAddon.NAME("BloodAltar");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BloodMagicRecipeType.ALTAR;
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeBloodAltar recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSOutput getOutput(RecipeBloodAltar recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"bloodmagic"}, priority=1)
    public static class BMARCMapper
    extends ARecipeTypeMapper<RecipeARC> {
        @Override
        public String getName() {
            return BloodMagicAddon.NAME("AlchemicalReactionChamber");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BloodMagicRecipeType.ARC;
        }

        @Override
        public NSSOutput getOutput(RecipeARC recipe) {
            ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
            outputs.add(recipe.getFluidOutput());
            outputs.addAll(recipe.getAllOutputs((Random)new FRandom(1L)));
            return this.mapOutputs(outputs.toArray());
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeARC recipe) {
            return Collections.singletonList(recipe.getInput());
        }

        @Override
        public NSSInput getInput(RecipeARC recipe) {
            return super.getInput(recipe);
        }
    }

    @RecipeTypeMapper(requiredMods={"bloodmagic"}, priority=1)
    public static class BMAlchemyArrayMapper
    extends ARecipeTypeMapper<RecipeAlchemyArray> {
        @Override
        public String getName() {
            return BloodMagicAddon.NAME("AlchemyArray");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BloodMagicRecipeType.ARRAY;
        }

        @Override
        public NSSOutput getOutput(RecipeAlchemyArray recipe) {
            return new NSSOutput(recipe.getOutput());
        }
    }

    @RecipeTypeMapper(requiredMods={"bloodmagic"}, priority=1)
    public static class BMAlchemyTableMapper
    extends ARecipeTypeMapper<RecipeAlchemyTable> {
        @Override
        public String getName() {
            return BloodMagicAddon.NAME("AlchemyTable");
        }

        @Override
        public NSSOutput getOutput(RecipeAlchemyTable recipe) {
            return new NSSOutput(recipe.getOutput());
        }

        @Override
        protected List<Ingredient> getIngredients(RecipeAlchemyTable recipe) {
            return recipe.getInput();
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == BloodMagicRecipeType.ALCHEMYTABLE;
        }
    }
}

