/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.BlockTransmutation;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInfusion;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;

public class AstralSorceryAddon {
    public static final String MODID = "astralsorcery";

    static String NAME(String name) {
        return "AstralSorcery" + name + "Mapper";
    }

    @ConversionProvider(value="astralsorcery")
    public static class ASConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.comment("default conversions for Astral Sorcery").before(ASConversionProvider.gemTag("aquamarine"), 128L).before(ASConversionProvider.tag("forge:marble"), 32L).before((IItemProvider)BlocksAS.MARBLE_RAW, 32L).before((IItemProvider)ItemsAS.ROCK_CRYSTAL, 256L).before((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL, 512L).conversion((IItemProvider)ItemsAS.STARMETAL_INGOT)).ingredient((IItemProvider)Items.field_151042_j)).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"astralsorcery"}, priority=1)
    public static class ASWellLiquefactionMapper
    extends ARecipeTypeMapper<WellLiquefaction> {
        @Override
        public String getName() {
            return AstralSorceryAddon.NAME("WellLiquefaction");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Disabled by default. Maps 1 Item to 1 bucket (" + 1000 + ')';
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypesAS.TYPE_WELL.getType();
        }

        public boolean isAvailable() {
            return false;
        }

        @Override
        public NSSOutput getOutput(WellLiquefaction recipe) {
            return new NSSOutput(new FluidStack(recipe.getFluidOutput(), 1000));
        }

        @Override
        protected List<Ingredient> getIngredients(WellLiquefaction recipe) {
            return Collections.singletonList(recipe.getInput());
        }
    }

    @RecipeTypeMapper(requiredMods={"astralsorcery"}, priority=1)
    public static class ASLiquidInfusionMapper
    extends ARecipeTypeMapper<LiquidInfusion> {
        @Override
        public String getName() {
            return AstralSorceryAddon.NAME("LiquidInfusion");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypesAS.TYPE_INFUSION.getType();
        }

        @Override
        public NSSOutput getOutput(LiquidInfusion recipe) {
            return new NSSOutput(recipe.getOutput(ItemStack.field_190927_a));
        }

        @Override
        protected List<Ingredient> getIngredients(LiquidInfusion recipe) {
            return Collections.singletonList(recipe.getItemInput());
        }
    }

    @RecipeTypeMapper(requiredMods={"astralsorcery"}, priority=1)
    public static class ASBlockTransmutationMapper
    extends ARecipeTypeMapper<BlockTransmutation> {
        @Override
        public String getName() {
            return AstralSorceryAddon.NAME("BlockTransmutation");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypesAS.TYPE_BLOCK_TRANSMUTATION.getType();
        }

        @Override
        public NSSOutput getOutput(BlockTransmutation recipe) {
            return new NSSOutput(recipe.getOutputDisplay());
        }

        @Override
        protected List<Ingredient> getIngredients(BlockTransmutation recipe) {
            return Collections.singletonList(Ingredient.func_234819_a_(recipe.getInputDisplay().stream()));
        }
    }

    @RecipeTypeMapper(requiredMods={"astralsorcery"}, priority=1)
    public static class ASAltarMapper
    extends ARecipeTypeMapper<SimpleAltarRecipe> {
        @Override
        public String getName() {
            return AstralSorceryAddon.NAME("Altar");
        }

        public boolean canHandle(IRecipeType<?> iRecipeType) {
            return iRecipeType == RecipeTypesAS.TYPE_ALTAR.getType();
        }

        @Override
        public NSSInput getInput(SimpleAltarRecipe recipe) {
            AltarRecipeGrid grid = recipe.getInputs();
            IngredientMap ingredientMap = new IngredientMap();
            ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> fakeGroupMap = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
            for (int slot = 0; slot < 25; ++slot) {
                this.convertIngredient(grid.getIngredient(slot), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            }
            for (WrappedIngredient relayInput : recipe.getRelayInputs()) {
                this.convertIngredient(relayInput.getIngredient(), (IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap);
            }
            return new NSSInput((IngredientMap<NormalizedSimpleStack>)ingredientMap, fakeGroupMap, true);
        }

        @Override
        public NSSOutput getOutput(SimpleAltarRecipe recipe) {
            try {
                return this.mapOutputs(recipe.getOutputs(null).toArray());
            }
            catch (Exception e) {
                PEIntegration.LOGGER.info("Failed to get outputs for Altar Recipe", (Throwable)e);
                return null;
            }
        }
    }
}

