/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import al132.alchemistry.RecipeTypes;
import al132.alchemistry.blocks.atomizer.AtomizerRecipe;
import al132.alchemistry.blocks.combiner.CombinerRecipe;
import al132.alchemistry.blocks.evaporator.EvaporatorRecipe;
import al132.alchemistry.blocks.fission.FissionRecipe;
import al132.alchemistry.blocks.liquifier.LiquifierRecipe;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSInput;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import java.util.List;
import java.util.stream.Collectors;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;

public class AlchemistryAddon {
    public static final String MODID = "alchemistry";

    public static String NAME(String name) {
        return "Alchemistry" + name + "Mapper";
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryLiquifierMapper
    extends ARecipeTypeMapper<LiquifierRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Liquifier");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == RecipeTypes.LIQUIFIER;
        }

        @Override
        public NSSOutput getOutput(LiquifierRecipe recipe) {
            return new NSSOutput(recipe.output);
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryFusionMapper
    extends ARecipeTypeMapper<FissionRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Fusion");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == RecipeTypes.FISSION;
        }

        @Override
        public NSSOutput getOutput(FissionRecipe recipe) {
            return this.mapOutputs(recipe.getOutputs().toArray());
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryEvaporatorMapper
    extends ARecipeTypeMapper<EvaporatorRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Evaporator");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == RecipeTypes.EVAPORATOR;
        }

        @Override
        public NSSInput getInput(EvaporatorRecipe recipe) {
            return NSSInput.createFluid(recipe.input);
        }

        @Override
        public NSSOutput getOutput(EvaporatorRecipe recipe) {
            return new NSSOutput(recipe.output);
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryCombinerMapper
    extends ARecipeTypeMapper<CombinerRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Combiner");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == RecipeTypes.COMBINER;
        }

        @Override
        protected List<Ingredient> getIngredients(CombinerRecipe recipe) {
            return recipe.getEmptyStrippedInputs().stream().map(xva$0 -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{xva$0})).collect(Collectors.toList());
        }
    }

    @RecipeTypeMapper(requiredMods={"alchemistry"}, priority=1)
    public static class AlchemistryAtomizerMapper
    extends ARecipeTypeMapper<AtomizerRecipe> {
        @Override
        public String getName() {
            return AlchemistryAddon.NAME("Atomizer");
        }

        public boolean canHandle(IRecipeType<?> recipeType) {
            return recipeType == RecipeTypes.ATOMIZER;
        }

        @Override
        public NSSInput getInput(AtomizerRecipe recipe) {
            return NSSInput.createFluid(recipe.input);
        }
    }
}

