/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.biome.BiomeUtil;

public class SeasonHooks {
    public static float getBiomeTemperatureHook(Biome biome, BlockPos pos, IWorldReader worldReader) {
        if (!(worldReader instanceof World)) {
            return biome.func_225486_c(pos);
        }
        return SeasonHooks.getBiomeTemperature((World)worldReader, biome, pos);
    }

    public static float getBiomeTemperature(World world, Biome biome, BlockPos pos) {
        return SeasonHooks.getBiomeTemperature(world, biome, (RegistryKey<Biome>)((RegistryKey)world.func_242406_i(pos).orElse(null)), pos);
    }

    public static float getBiomeTemperature(World world, RegistryKey<Biome> key, BlockPos pos) {
        return SeasonHooks.getBiomeTemperature(world, world.func_226691_t_(pos), key, pos);
    }

    public static float getBiomeTemperature(World world, Biome biome, RegistryKey<Biome> key, BlockPos pos) {
        if (!SeasonsConfig.isDimensionWhitelisted((RegistryKey<World>)world.func_234923_W_())) {
            return biome.func_225486_c(pos);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(world).getSeasonCycleTicks()).getSubSeason(), biome, key, pos);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, Biome biome, RegistryKey<Biome> key, BlockPos pos) {
        boolean tropicalBiome = BiomeConfig.usesTropicalSeasons(key);
        float biomeTemp = biome.func_225486_c(pos);
        if (!tropicalBiome && biome.func_242445_k() <= 0.8f && BiomeConfig.enablesSeasonalEffects(key)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }

    public static boolean shouldRainInBiomeInSeason(World world, RegistryKey<Biome> biomeKey) {
        Biome biome = BiomeUtil.getBiome(biomeKey);
        if (BiomeConfig.usesTropicalSeasons(biomeKey)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
        }
        return biome.func_201851_b() == Biome.RainType.RAIN;
    }
}

