/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.damage.IDraconicDamage;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.items.equipment.DEItemTier;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModularSword
extends SwordItem
implements IReaperItem,
IModularMelee,
IDraconicDamage {
    private final TechLevel techLevel;
    private final DEItemTier itemTier;

    public ModularSword(TechPropBuilder props) {
        super((IItemTier)new DEItemTier(props, EquipCfg::getSwordDmgMult, EquipCfg::getSwordSpeedMult), 0, 0.0f, props.build().func_234689_a_());
        this.techLevel = props.techLevel;
        this.itemTier = (DEItemTier)this.func_200891_e();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DEItemTier getItemTier() {
        return this.itemTier;
    }

    @Override
    public TechLevel getTechLevel(@Nullable ItemStack stack) {
        return this.techLevel;
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "sword", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        return new ModularOPStorage(host, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index;
    }
}

