/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.DEItemTier;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.google.common.collect.Multimap;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IModularTieredItem
extends IModularItem {
    public DEItemTier getItemTier();

    @Override
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = IModularItem.super.getAttributeModifiers(slot, stack);
        if (stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            DEItemTier tier = this.getItemTier();
            if (slot == EquipmentSlotType.MAINHAND) {
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                double damage = this.getAttackDamage(host, stack);
                double speed = 1.0 + host.getModuleData(ModuleTypes.SPEED, new SpeedData(0.0)).getSpeedMultiplier();
                map.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", damage, AttributeModifier.Operation.ADDITION));
                map.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(Item.field_185050_h, "Tool modifier", (double)tier.getAttackSpeed() * speed - 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return map;
    }

    default public double getAttackDamage(ModuleHost host, ItemStack stack) {
        double damage = host.getModuleData(ModuleTypes.DAMAGE, new DamageData(0.0)).getDamagePoints();
        if ((double)this.getEnergyStored(stack) < (double)EquipCfg.energyAttack * damage) {
            damage = 0.0;
        }
        return damage + (double)(this.getItemTier().func_200929_c() - 1.0f);
    }
}

