/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.entity.PersistentItemEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;

public interface IModularItem
extends IForgeItem,
IFusionDataTransfer {
    public TechLevel getTechLevel();

    default public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (DECapabilities.MODULE_HOST_CAPABILITY == null || DECapabilities.PROPERTY_PROVIDER_CAPABILITY == null || DECapabilities.OP_STORAGE == null) {
            return null;
        }
        MultiCapabilityProvider provider = new MultiCapabilityProvider();
        ModuleHostImpl host = this.createHost(stack);
        provider.addCapability((INBTSerializable)host, "module_host", new Capability[]{DECapabilities.MODULE_HOST_CAPABILITY, DECapabilities.PROPERTY_PROVIDER_CAPABILITY});
        ModularOPStorage opStorage = this.createOPStorage(stack, host);
        if (opStorage != null) {
            provider.addCapability((INBTSerializable)opStorage, "energy", new Capability[]{DECapabilities.OP_STORAGE, CapabilityEnergy.ENERGY});
            host.addCategories(ModuleCategory.ENERGY);
        }
        if (this instanceof IModularMiningTool) {
            host.addCategories(ModuleCategory.MINING_TOOL);
            host.addPropertyBuilder(props -> {
                props.add(new DecimalProperty("mining_speed", 1.0).range(0.0, 1.0).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_1));
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new IntegerProperty("mining_aoe", aoe.getAOE()).range(0, aoe.getAOE()).setFormatter(ConfigProperty.IntegerFormatter.AOE));
                    props.add(new BooleanProperty("aoe_safe", false).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED));
                }
            });
        }
        if (this instanceof IModularMelee) {
            host.addCategories(ModuleCategory.MELEE_WEAPON);
            host.addPropertyBuilder(props -> {
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new DecimalProperty("attack_aoe", (double)aoe.getAOE() * 1.5).range(0.0, (double)aoe.getAOE() * 1.5).setFormatter(ConfigProperty.DecimalFormatter.AOE_1));
                }
            });
        }
        this.initCapabilities(stack, host, provider);
        return provider;
    }

    default public void initCapabilities(ItemStack stack, ModuleHostImpl host, MultiCapabilityProvider provider) {
    }

    public ModuleHostImpl createHost(ItemStack var1);

    @Nullable
    public ModularOPStorage createOPStorage(ItemStack var1, ModuleHostImpl var2);

    @OnlyIn(value=Dist.CLIENT)
    default public void addModularItemInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("[Modular Item]").func_240699_a_(TextFormatting.BLUE));
        }
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
        if (EnergyUtils.isEnergyItem((ItemStack)stack) && EnergyUtils.getMaxEnergyStored((ItemStack)stack) == 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.requires_energy").func_240699_a_(TextFormatting.RED));
            if (KeyBindings.toolModules != null && KeyBindings.toolModules.func_238171_j_() != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.requires_energy_press", new Object[]{KeyBindings.toolModules.func_238171_j_().getString()}).func_240699_a_(TextFormatting.BLUE));
            }
        }
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        return map;
    }

    default public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlotType slot, boolean inEquipModSlot) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        StackModuleContext context = new StackModuleContext(stack, entity, slot).setInEquipModSlot(inEquipModSlot);
        host.handleTick(context);
    }

    default public boolean isEquipped(ItemStack stack, @Nullable EquipmentSlotType slot, boolean inEquipSlot) {
        if (this instanceof IModularArmor) {
            return slot != null && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR || inEquipSlot;
        }
        return true;
    }

    default public float getDestroySpeed(ItemStack stack, BlockState state) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float moduleValue = data == null ? 0.0f : (float)data.getSpeedMultiplier();
        float multiplier = MathHelper.map((float)((moduleValue + 1.0f) * (moduleValue + 1.0f)), (float)1.0f, (float)2.0f, (float)1.0f, (float)1.65f);
        float propVal = 1.0f;
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("mining_speed")) {
            propVal = (float)((PropertyProvider)((Object)host)).getDecimal("mining_speed").getValue();
            propVal *= propVal;
        }
        float aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).getAOE();
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasInt("mining_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getInt("mining_aoe").getValue();
        }
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest) {
            multiplier = 0.0f;
        } else if (aoe > 0.0f) {
            float userTarget = multiplier * propVal;
            multiplier = Math.min(userTarget, multiplier / (1.0f + aoe * 10.0f));
        } else {
            multiplier *= propVal;
        }
        if (this.isToolEffective(stack, state) && (multiplier > 0.0f || propVal == 0.0f)) {
            return this.getBaseEfficiency() * multiplier;
        }
        return propVal == 0.0f ? 0.0f : 1.0f;
    }

    default public boolean isToolEffective(ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) || this.overrideEffectivity(state.func_185904_a()) || this.effectiveBlockAdditions().contains(state.func_177230_c());
    }

    default public float getBaseEfficiency() {
        return 1.0f;
    }

    default public Set<Block> effectiveBlockAdditions() {
        return Collections.emptySet();
    }

    default public boolean overrideEffectivity(Material material) {
        return false;
    }

    @Nullable
    default public CompoundNBT getShareTag(ItemStack stack) {
        return DECapabilities.writeToShareTag(stack, stack.func_77978_p());
    }

    default public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        stack.func_77982_d(nbt);
        DECapabilities.readFromShareTag(stack, nbt);
    }

    default public long getEnergyStored(ItemStack stack) {
        return EnergyUtils.getEnergyStored((ItemStack)stack);
    }

    default public long extractEnergy(PlayerEntity player, ItemStack stack, long amount) {
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return amount;
        }
        IOPStorage storage = EnergyUtils.getStorage((ItemStack)stack);
        if (storage instanceof IOPStorageModifiable) {
            return ((IOPStorageModifiable)storage).modifyEnergyStored(-amount);
        }
        if (storage != null) {
            return storage.extractOP(amount, false);
        }
        return 0L;
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        long max = EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        return max > 0L && EnergyUtils.getEnergyStored((ItemStack)stack) < max;
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)EnergyUtils.getEnergyStored((ItemStack)stack) / (double)EnergyUtils.getMaxEnergyStored((ItemStack)stack);
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new PersistentItemEntity(world, location, itemstack);
    }
}

