/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.computers;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;

public class CCOCIntegration {
    public static void init() {
        if (ModList.get().isLoaded("computercraft")) {
            CCOCIntegration.initCC();
        }
        if (ModList.get().isLoaded("opencomputers")) {
            CCOCIntegration.initOC();
        }
    }

    public static void initCC() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new DEPeripheralProvider());
    }

    public static void initOC() {
    }

    public static class DEPeripheralProvider
    implements IPeripheralProvider {
        private IPeripheral peripheral;
        private LazyOptional<IPeripheral> holderPeripheral;

        @Nullable
        public LazyOptional<IPeripheral> getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IPeripheral) {
                this.setPeripheral((IPeripheral)tile);
                return this.holderPeripheral;
            }
            return null;
        }

        protected void setPeripheral(IPeripheral peripheral) {
            this.peripheral = peripheral;
            this.holderPeripheral = LazyOptional.of(() -> peripheral);
        }
    }
}

