/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.achievements.Achievements;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerChangeGameModeEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DEEventHandler {
    private static WeakHashMap<MobEntity, Long> deSpawnedMobs = new WeakHashMap();
    private static Random random = new Random();
    public static int serverTicks = 0;
    List<UUID> deadDragons = new LinkedList<UUID>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void changeGameMode(ClientPlayerChangeGameModeEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (DEConfig.creativeWarning && event.getNewGameMode() == GameType.CREATIVE && player != null && !Minecraft.func_71410_x().func_71387_A() && player.func_146103_bH().equals((Object)event.getInfo().func_178845_a())) {
            player.func_145747_a((ITextComponent)new StringTextComponent("[Draconic Evolution]: ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new StringTextComponent("Warning! Using creative inventory on a server will delete all module data on DE tools and armor. This is due a fundamental issue with the creative menu.").func_240699_a_(TextFormatting.RED)), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CrystalUpdateBatcher.tickEnd();
            ++serverTicks;
            if (!deSpawnedMobs.isEmpty()) {
                ArrayList toRemove = new ArrayList();
                long time = System.currentTimeMillis();
                deSpawnedMobs.forEach((entity, aLong) -> {
                    if (time - aLong > 30000L) {
                        entity.field_82179_bU = false;
                        toRemove.add(entity);
                    }
                });
                toRemove.forEach(entity -> deSpawnedMobs.remove(entity));
            }
        }
    }

    public static void onMobSpawnedBySpawner(MobEntity entity) {
        deSpawnedMobs.put(entity, System.currentTimeMillis());
    }

    @SubscribeEvent
    public void onDropEvent(LivingDropsEvent event) {
        this.handleDragonDrops(event);
        this.handleSoulDrops(event);
    }

    private void handleDragonDrops(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (this.deadDragons.contains(entity.func_110124_au())) {
            LogHelper.dev("WTF Is Going On!?!?!? The dragon is already dead how can it die again!?!?!");
            LogHelper.dev("Whoever is screwing with the dragon you need to fix your shit!");
            LogHelper.dev("Offending Entity: " + entity + " Class: " + entity.getClass());
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            LogHelper.dev("****************************************");
            for (int i = 2; i < trace.length; ++i) {
                LogHelper.dev("*  at %s", trace[i].toString());
            }
            LogHelper.dev("****************************************");
            event.setCanceled(true);
            return;
        }
        if (!entity.field_70170_p.field_72995_K && (entity instanceof EnderDragonEntity || entity instanceof DraconicGuardianEntity)) {
            this.deadDragons.add(entity.func_110124_au());
            ItemEntity item = (ItemEntity)EntityType.field_200765_E.func_200721_a(entity.field_70170_p);
            if (item != null) {
                item.func_92058_a(new ItemStack((IItemProvider)DEContent.dragon_heart));
                BlockPos podiumPos = entity.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, EndPodiumFeature.field_186139_a).func_177982_a(0, 3, 0);
                item.func_70012_b((double)podiumPos.func_177958_n() + 0.5, (double)podiumPos.func_177956_o(), (double)podiumPos.func_177952_p() + 0.5, 0.0f, 0.0f);
                item.func_213293_j(0.0, 0.0, 0.0);
                item.field_70292_b = -32767;
                item.func_189654_d(true);
                entity.field_70170_p.func_217376_c((Entity)item);
            }
            if (entity instanceof EnderDragonEntity) {
                DragonFightManager manager = ((EnderDragonEntity)entity).func_184664_cU();
                if (DEConfig.dragonEggSpawnOverride && manager != null && manager.func_186102_d()) {
                    entity.field_70170_p.func_175656_a(entity.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, EndPodiumFeature.field_186139_a).func_177982_a(0, 0, -4), Blocks.field_150380_bt.func_176223_P());
                }
            }
            if (DEConfig.dragonDustLootModifier > 0) {
                double count = (double)DEConfig.dragonDustLootModifier * 0.9 + entity.field_70170_p.field_73012_v.nextDouble() * ((double)DEConfig.dragonDustLootModifier * 0.2);
                for (int i = 0; i < (int)count; ++i) {
                    float mm = 0.3f;
                    ItemEntity dust = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_() - 2.0 + (double)entity.field_70170_p.field_73012_v.nextInt(4), entity.func_226278_cu_() - 2.0 + (double)entity.field_70170_p.field_73012_v.nextInt(4), entity.func_226281_cx_() - 2.0 + (double)entity.field_70170_p.field_73012_v.nextInt(4), new ItemStack((IItemProvider)DEContent.dust_draconium));
                    dust.func_213293_j((double)(mm * ((float)entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f)), (double)(mm * ((float)entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f)), (double)(mm * ((float)entity.field_70170_p.field_73012_v.nextInt(100) / 100.0f - 0.5f)));
                    entity.field_70170_p.func_217376_c((Entity)dust);
                }
            }
        }
    }

    private void handleSoulDrops(LivingDropsEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !event.getSource().field_76373_n.equals("player") && !event.getSource().field_76373_n.equals("arrow") || !MobSoul.isValidEntity(event.getEntityLiving())) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        Entity attacker = event.getSource().func_76346_g();
        if (attacker == null || !(attacker instanceof PlayerEntity) || entity instanceof PlayerEntity) {
            return;
        }
        int dropChanceModifier = this.getDropChanceFromItem(((PlayerEntity)attacker).func_184614_ca());
        if (dropChanceModifier == 0) {
            return;
        }
        World world = entity.field_70170_p;
        int rand = random.nextInt(Math.max(DEConfig.soulDropChance / dropChanceModifier, 1));
        int rand2 = random.nextInt(Math.max(DEConfig.passiveSoulDropChance / dropChanceModifier, 1));
        boolean isAnimal = entity instanceof AnimalEntity;
        if (rand == 0 && !isAnimal || rand2 == 0 && isAnimal) {
            ItemStack soul = DEContent.mob_soul.getSoulFromEntity((Entity)entity, false);
            world.func_217376_c((Entity)new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), soul));
            Achievements.triggerAchievement((PlayerEntity)attacker, "draconicevolution.soul");
        }
    }

    private int getDropChanceFromItem(ItemStack stack) {
        int chance = 0;
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IReaperItem) {
            chance = ((IReaperItem)stack.func_77973_b()).getReaperLevel(stack);
        }
        return chance += EnchantmentHelper.func_77506_a((Enchantment)DEContent.reaperEnchant, (ItemStack)stack);
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        ItemEntity item = event.getEntityItem();
        PlayerEntity player = event.getPlayer();
        if (DEOldConfig.forceDroppedItemOwner && player != null && item.func_200214_m() == null) {
            item.func_200216_c(player.func_110124_au());
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        ItemStack other = player.func_184586_b(event.getHand() == Hand.OFF_HAND ? Hand.MAIN_HAND : Hand.OFF_HAND);
        if (stack.func_77973_b() instanceof ICrystalBinder && other.func_77973_b() instanceof ICrystalBinder) {
            if (event.getHand() == Hand.OFF_HAND) {
                event.setCanceled(true);
                return;
            }
        } else {
            if (event.getHand() == Hand.OFF_HAND && other.func_77973_b() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
            if (event.getHand() == Hand.MAIN_HAND && other.func_77973_b() instanceof ICrystalBinder) {
                event.setCanceled(true);
                return;
            }
        }
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICrystalBinder)) {
            return;
        }
        if (BinderHandler.onBinderUse(event.getPlayer(), event.getHand(), event.getWorld(), event.getPos(), stack, event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K || event.isCanceled() || !event.getPlayer().func_225608_bj_() || !(event.getItemStack().func_77973_b() instanceof ICrystalBinder)) {
            return;
        }
        BlockRayTraceResult traceResult = RayTracer.retrace((PlayerEntity)event.getPlayer());
        if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return;
        }
        if (BinderHandler.clearBinder(event.getPlayer(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void itemTooltipEvent(ItemTooltipEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        float newDigSpeed;
        if (event.getPlayer() != null && (newDigSpeed = event.getOriginalSpeed()) != event.getOriginalSpeed()) {
            event.setNewSpeed(newDigSpeed);
        }
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().func_233570_aj_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof GuardianCrystalEntity) {
            event.setCanceled(true);
        }
    }
}

