/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianWither;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GroundEffectPhase
extends ChargeUpPhase {
    private List<MobEntity> summoned = new ArrayList<MobEntity>();
    private int initialWithers = 0;
    private int spawnCount = 0;
    private int nextWither = 0;
    private int withersKilled = 0;
    private int attackStage = 0;
    private int actionDuration = 0;
    private int actionTime = 0;

    public GroundEffectPhase(DraconicGuardianEntity guardian) {
        super(guardian, 100);
        this.disableFlight = true;
        this.trapPlayers = true;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.summoned == null) {
            this.guardian.field_70170_p.func_217394_a(DEContent.guardianWither, this.guardian.func_174813_aQ().func_186662_g(500.0), e -> true).forEach(Entity::func_70106_y);
            this.summoned = new ArrayList<MobEntity>();
        }
        if (!this.isCharged()) {
            return;
        }
        this.updateWithers();
        if (this.attackStage == 0 && this.withersKilled < this.initialWithers && this.chargedTime < 3600) {
            return;
        }
        if (this.actionTime >= this.actionDuration) {
            this.chargeTime = 0;
            this.sendPacket(null, 0);
            this.actionDuration = 120 + this.random.nextInt(120);
            this.actionTime = 0;
            ++this.attackStage;
            return;
        }
        ++this.actionTime;
        switch (this.attackStage) {
            case 0: {
                ++this.attackStage;
            }
            case 1: {
                this.updateSpinFire();
                break;
            }
            case 2: {
                this.updateSpinFire();
                break;
            }
            case 3: {
                this.updateRandomFire();
                if (this.actionTime < this.actionDuration) break;
                this.guardian.getPhaseManager().setPhase(PhaseType.START);
                this.guardian.field_70170_p.func_217394_a(DEContent.guardianWither, this.guardian.func_174813_aQ().func_186662_g(500.0), e -> true).forEach(Entity::func_70106_y);
            }
        }
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.initialWithers = 8 + this.random.nextInt(6);
        this.summoned = null;
        this.withersKilled = 0;
        this.spawnCount = 0;
        this.actionDuration = 0;
        this.attackStage = 0;
    }

    private void updateWithers() {
        this.withersKilled = (int)((long)this.withersKilled + this.summoned.stream().filter(e -> !e.func_70089_S()).count());
        this.summoned.removeIf(e -> !e.func_70089_S());
        if (this.nextWither > 0) {
            --this.nextWither;
            if (this.nextWither == 0) {
                this.summonWither(this.spawnCount < this.initialWithers);
            }
        } else if (this.spawnCount < this.initialWithers && this.chargedTime % 5 == 0) {
            this.nextWither = 3 + this.random.nextInt(5);
            ++this.spawnCount;
        } else if (this.spawnCount >= this.initialWithers && this.withersKilled >= this.initialWithers && this.summoned.size() < 2) {
            this.nextWither = 80 + this.random.nextInt(140);
        }
        for (MobEntity wither : this.summoned) {
            PlayerEntity closeTarget = this.guardian.field_70170_p.func_217366_a(wither.func_226277_ct_(), wither.func_226278_cu_(), wither.func_226281_cx_(), 200.0, true);
            if (closeTarget == null) continue;
            wither.func_70624_b((LivingEntity)closeTarget);
        }
    }

    private void summonWither(boolean canLoot) {
        GuardianWither wither = (GuardianWither)DEContent.guardianWither.func_200721_a(this.guardian.field_70170_p);
        Vector3 spawnPos = null;
        for (int i = 0; i < 10 && !(MathUtils.distanceSq((Vector3)(spawnPos = Vector3.fromEntity((Entity)this.guardian).add((double)(this.random.nextInt(80) - 40), (double)(this.random.nextInt(20) - 10), (double)(this.random.nextInt(80) - 40))), (Vector3)Vector3.fromEntity((Entity)this.guardian)) < 1600.0); ++i) {
        }
        wither.func_70107_b(spawnPos.x, spawnPos.y - 10.0, spawnPos.z);
        wither.func_200203_b((ITextComponent)new TranslationTextComponent("entity.draconicevolution.guardian_wither"));
        wither.func_82215_s(3);
        this.guardian.field_70170_p.func_217376_c((Entity)wither);
        this.summoned.add((MobEntity)wither);
        wither.field_82222_j = 10000;
    }

    private void updateSpinFire() {
        Vector3 headPos = Vector3.fromEntity((Entity)this.guardian);
        float rotation = (this.guardian.field_70126_B - 90.0f - 55.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(MathHelper.func_76134_b((float)rotation) * 7.0f), 0.0, (double)(MathHelper.func_76126_a((float)rotation) * 7.0f));
        boolean perimeterHit = this.attackStage == 1;
        rotation = (float)((double)rotation + 1.5707963267948966);
        BlockPos origin = this.guardian.getArenaOrigin();
        int range = perimeterHit ? 30 + this.random.nextInt(40) : this.random.nextInt(60);
        double targetX = this.guardian.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)rotation) * (float)range);
        double targetY = origin == null ? this.guardian.func_226278_cu_() - 30.0 : (double)(origin.func_177956_o() + 15);
        double targetZ = this.guardian.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)rotation) * (float)range);
        Vector3 aim = new Vector3(targetX, targetY, targetZ).subtract(headPos).normalize();
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.field_70170_p, (LivingEntity)this.guardian, aim.x, aim.y, aim.z, null, 25.0, 15.0);
        projectile.func_70012_b(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
        this.guardian.field_70170_p.func_217376_c((Entity)projectile);
        BCoreNetwork.sendSound((World)this.guardian.field_70170_p, (Entity)this.guardian, (SoundEvent)SoundEvents.field_187527_aQ, (SoundCategory)SoundCategory.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
        BCoreNetwork.sendParticle((World)this.guardian.field_70170_p, (IParticleData)ParticleTypes.field_197627_t, (Vector3)headPos, (Vector3)Vector3.ZERO, (boolean)true);
        this.guardian.field_70177_z += 1.0f + (float)this.actionTime / (float)this.actionDuration * 10.0f;
    }

    private void updateRandomFire() {
        Vector3 headPos = Vector3.fromEntity((Entity)this.guardian);
        float rotation = (this.guardian.field_70126_B - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(MathHelper.func_76134_b((float)rotation) * 7.0f), 0.0, (double)(MathHelper.func_76126_a((float)rotation) * 7.0f));
        for (int i = 0; i < 2; ++i) {
            Vector3 target = Vector3.fromEntity((Entity)this.guardian).add((double)(this.random.nextInt(160) - 80), -30.0, (double)(this.random.nextInt(160) - 80));
            BlockPos origin = this.guardian.getArenaOrigin();
            if (origin != null) {
                target.y = origin.func_177956_o() + 15;
            }
            Vector3 aim = target.subtract(headPos).normalize().multiply(3.0);
            GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.field_70170_p, (LivingEntity)this.guardian, aim.x, aim.y, aim.z, null, 25.0, 15.0);
            projectile.func_70012_b(headPos.x, headPos.y, headPos.z, 0.0f, 0.0f);
            this.guardian.field_70170_p.func_217376_c((Entity)projectile);
        }
        BCoreNetwork.sendParticle((World)this.guardian.field_70170_p, (IParticleData)ParticleTypes.field_197627_t, (Vector3)headPos, (Vector3)Vector3.ZERO, (boolean)true);
        BCoreNetwork.sendSound((World)this.guardian.field_70170_p, (Entity)this.guardian, (SoundEvent)SoundEvents.field_187527_aQ, (SoundCategory)SoundCategory.HOSTILE, (float)32.0f, (float)((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f), (boolean)false);
        this.guardian.field_70177_z += 1.0f;
    }

    public PhaseType<GroundEffectPhase> getType() {
        return PhaseType.GROUND_EFFECTS;
    }

    protected final Vector3d calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

