/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianProjectileEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.Logger;

public class CoverFirePhase
extends Phase {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    private Path currentPath;
    private Vector3d targetLocation;
    private boolean clockwise;
    private int tick;

    public CoverFirePhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<CoverFirePhase> getType() {
        return PhaseType.COVER_FIRE;
    }

    @Override
    public void serverTick() {
        double distanceFromTarget;
        Vector3d vector3d2 = this.guardian.func_70676_i(1.0f);
        double headX = this.guardian.dragonPartHead.func_226277_ct_() - vector3d2.field_72450_a * 1.0;
        double headY = this.guardian.dragonPartHead.func_226283_e_(0.5) + 0.5;
        double headZ = this.guardian.dragonPartHead.func_226281_cx_() - vector3d2.field_72449_c * 1.0;
        Vector3d targetPos = this.guardian.func_213303_ch();
        targetPos = targetPos.func_72441_c((this.guardian.func_70681_au().nextDouble() - 0.5) * 50.0, (this.guardian.func_70681_au().nextDouble() - 0.5) * 50.0, (this.guardian.func_70681_au().nextDouble() - 0.5) * 50.0);
        double targetRelX = targetPos.field_72450_a - headX;
        double targetRelY = targetPos.field_72448_b - headY;
        double targetRelZ = targetPos.field_72449_c - headZ;
        if (!this.guardian.func_174814_R()) {
            this.guardian.field_70170_p.func_217378_a(null, 1017, this.guardian.func_233580_cy_(), 0);
        }
        GuardianProjectileEntity projectile = new GuardianProjectileEntity(this.guardian.field_70170_p, (LivingEntity)this.guardian, targetRelX, targetRelY, targetRelZ, targetPos, 25.0, 15.0);
        projectile.func_70012_b(headX, headY, headZ, 0.0f, 0.0f);
        this.guardian.field_70170_p.func_217376_c((Entity)projectile);
        double d = distanceFromTarget = this.targetLocation == null ? 0.0 : this.targetLocation.func_186679_c(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_(), this.guardian.func_226281_cx_());
        if (this.currentPath != null && this.currentPath.func_75879_b() && distanceFromTarget < 100.0) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
            return;
        }
        if (distanceFromTarget < 100.0) {
            this.updatePathing();
        }
        if (this.tick++ > 60) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START).immediateAttack(null);
        }
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
        this.tick = 0;
    }

    private void updatePathing() {
        if (this.currentPath == null || this.currentPath.func_75879_b()) {
            int nearestIndex;
            int endIndex = nearestIndex = this.guardian.initPathPoints(false);
            if (this.guardian.func_70681_au().nextInt(8) == 0) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            endIndex = this.clockwise ? (endIndex += 12) : (endIndex -= 12);
            endIndex = Math.floorMod(endIndex, 24);
            this.currentPath = this.guardian.findPath(nearestIndex, endIndex, null);
            if (this.currentPath != null) {
                this.currentPath.func_75875_a();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            BlockPos nextPos = this.currentPath.func_242948_g();
            this.currentPath.func_75875_a();
            double x = nextPos.func_177958_n();
            double z = nextPos.func_177952_p();
            double y = (float)nextPos.func_177956_o() + this.guardian.func_70681_au().nextFloat() * 20.0f;
            this.targetLocation = new Vector3d(x, y, z);
        }
    }

    @Override
    public double getGuardianSpeed() {
        return 3.0;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }
}

