/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FusionRecipeBuilder {
    private final ItemStack result;
    private Ingredient catalyst = null;
    private long energy = -1L;
    private TechLevel techLevel = null;
    private List<FusionRecipe.FusionIngredient> ingredients = new ArrayList<FusionRecipe.FusionIngredient>();

    public FusionRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public static FusionRecipeBuilder fusionRecipe(IItemProvider resultIn) {
        return FusionRecipeBuilder.fusionRecipe(resultIn, 1);
    }

    public static FusionRecipeBuilder fusionRecipe(IItemProvider resultIn, int countIn) {
        return FusionRecipeBuilder.fusionRecipe(new ItemStack(resultIn, countIn));
    }

    public static FusionRecipeBuilder fusionRecipe(ItemStack result) {
        return new FusionRecipeBuilder(result);
    }

    public FusionRecipeBuilder catalyst(ITag<Item> catalyst) {
        return this.catalyst(Ingredient.func_199805_a(catalyst));
    }

    public FusionRecipeBuilder catalyst(IItemProvider ... catalyst) {
        return this.catalyst(Ingredient.func_199804_a((IItemProvider[])catalyst));
    }

    public FusionRecipeBuilder catalyst(ItemStack ... catalyst) {
        return this.catalyst(Ingredient.func_193369_a((ItemStack[])catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, ITag<Item> catalyst) {
        return this.catalyst(IngredientStack.fromTag(catalyst, count));
    }

    public FusionRecipeBuilder catalyst(int count, IItemProvider ... catalyst) {
        return this.catalyst(IngredientStack.fromItems(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, ItemStack ... catalyst) {
        return this.catalyst(IngredientStack.fromStacks(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(Ingredient catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public FusionRecipeBuilder energy(long totalEnergy) {
        this.energy = totalEnergy;
        return this;
    }

    public FusionRecipeBuilder techLevel(TechLevel techLevel) {
        this.techLevel = techLevel;
        return this;
    }

    public FusionRecipeBuilder ingredient(boolean consume, Ingredient ingredient) {
        this.ingredients.add(new FusionRecipe.FusionIngredient(ingredient, consume));
        return this;
    }

    public FusionRecipeBuilder ingredient(Ingredient ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, ItemStack ... ingredient) {
        return this.ingredient(consume, Ingredient.func_193369_a((ItemStack[])ingredient));
    }

    public FusionRecipeBuilder ingredient(ItemStack ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, IItemProvider ... ingredient) {
        return this.ingredient(consume, Ingredient.func_199804_a((IItemProvider[])ingredient));
    }

    public FusionRecipeBuilder ingredient(IItemProvider ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, ITag<Item> ingredient) {
        return this.ingredient(consume, Ingredient.func_199805_a(ingredient));
    }

    public FusionRecipeBuilder ingredient(ITag<Item> ingredient) {
        return this.ingredient(true, ingredient);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.func_77973_b().getRegistryName());
    }

    public void build(Consumer<IFinishedRecipe> consumer, String save) {
        ResourceLocation resourcelocation = this.result.func_77973_b().getRegistryName();
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Fusion Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.result.func_190926_b()) {
            return;
        }
        this.validate(id);
        consumer.accept(new Result(id, this.result, this.catalyst, this.energy, this.techLevel, this.ingredients));
    }

    private void validate(ResourceLocation id) {
        if (this.catalyst == null) {
            throw new IllegalStateException("No catalyst is defined for fusion recipe " + id + "!");
        }
        if (this.energy == -1L) {
            throw new IllegalStateException("Energy requirement is not defined for fusion recipe " + id + "!");
        }
        if (this.techLevel == null) {
            throw new IllegalStateException("No TechLevel (crafting tier) is defined for fusion recipe " + id + "!");
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients are defined for fusion recipe " + id + "!");
        }
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_190916_E() != 1) {
            json.addProperty("count", (Number)stack.func_190916_E());
        }
        if (stack.func_77942_o()) {
            json.addProperty("nbt", stack.func_77978_p().toString());
        }
        return json;
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final Ingredient catalyst;
        private final TechLevel techLevel;
        private final Collection<FusionRecipe.FusionIngredient> ingredients;
        private final long energy;

        public Result(ResourceLocation id, ItemStack result, Ingredient catalyst, long energy, TechLevel techLevel, Collection<FusionRecipe.FusionIngredient> ingredients) {
            this.id = id;
            this.result = result;
            this.catalyst = catalyst;
            this.energy = energy;
            this.techLevel = techLevel;
            this.ingredients = ingredients;
        }

        public void func_218610_a(JsonObject json) {
            json.add("result", (JsonElement)FusionRecipeBuilder.writeItemStack(this.result));
            json.add("catalyst", this.catalyst.func_200304_c());
            json.addProperty("total_energy", (Number)this.energy);
            json.addProperty("tier", this.techLevel.name());
            JsonArray ingredientArray = new JsonArray();
            for (FusionRecipe.FusionIngredient ingredient : this.ingredients) {
                JsonElement element = ingredient.get().func_200304_c();
                if (!ingredient.consume()) {
                    JsonObject object = new JsonObject();
                    object.addProperty("consume", Boolean.valueOf(false));
                    object.add("ingredient", element);
                    ingredientArray.add((JsonElement)object);
                    continue;
                }
                ingredientArray.add(element);
            }
            json.add("ingredients", (JsonElement)ingredientArray);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return DraconicAPI.FUSION_RECIPE_SERIALIZER;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

