/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.datagen.BlockStateGenerator;
import com.brandon3055.draconicevolution.datagen.ItemModelGenerator;
import com.brandon3055.draconicevolution.datagen.LangGenerator;
import com.brandon3055.draconicevolution.datagen.LootTableGenerator;
import com.brandon3055.draconicevolution.datagen.RecipeGenerator;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenEventHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new LangGenerator(gen));
            gen.func_200390_a((IDataProvider)new BlockStateGenerator(gen, event.getExistingFileHelper()));
            gen.func_200390_a((IDataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new RecipeGenerator(gen));
            gen.func_200390_a((IDataProvider)new LootTableGenerator(gen));
            BlockTagGenerator blockGenerator = new BlockTagGenerator(gen, "draconicevolution", event.getExistingFileHelper());
            gen.func_200390_a((IDataProvider)blockGenerator);
            gen.func_200390_a((IDataProvider)new ItemTagGenerator(gen, blockGenerator, "draconicevolution", event.getExistingFileHelper()));
        }
    }

    private static class AdvancementBuilder
    extends AdvancementProvider {
        private DataGenerator generator;
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

        public AdvancementBuilder(DataGenerator generator) {
            super(generator);
            this.generator = generator;
        }

        private void aggAdvancements(Consumer<Advancement> consumer) {
        }

        public void func_200398_a(DirectoryCache cache) throws IOException {
            Path path = this.generator.func_200391_b();
            HashSet set = Sets.newHashSet();
            Consumer<Advancement> consumer = advancement -> {
                if (!set.add(advancement.func_192067_g())) {
                    throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
                }
                Path path1 = this.makePath(advancement.func_192067_g());
                try {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
                }
                catch (IOException ioexception) {
                    DraconicEvolution.LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
                }
            };
            this.aggAdvancements(consumer);
        }

        protected Path makePath(ResourceLocation id) {
            return this.generator.func_200391_b().resolve("data/" + id.func_110624_b() + "/advancements/" + id.func_110623_a() + ".json");
        }
    }

    private static class BlockTagGenerator
    extends BlockTagsProvider {
        public BlockTagGenerator(DataGenerator generatorIn, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_((ITag.INamedTag)DETags.Blocks.STORAGE_BLOCKS_DRACONIUM).func_240532_a_((Object)DEContent.block_draconium);
            this.func_240522_a_((ITag.INamedTag)DETags.Blocks.STORAGE_BLOCKS_DRACONIUM_AWAKENED).func_240532_a_((Object)DEContent.block_draconium_awakened);
            this.func_240522_a_((ITag.INamedTag)Tags.Blocks.STORAGE_BLOCKS).func_240534_a_((Object[])new Block[]{DEContent.block_draconium, DEContent.block_draconium_awakened});
            this.func_240522_a_((ITag.INamedTag)DETags.Blocks.ORES_DRACONIUM).func_240534_a_((Object[])new Block[]{DEContent.ore_draconium_end, DEContent.ore_draconium_nether, DEContent.ore_draconium_overworld});
            this.func_240522_a_((ITag.INamedTag)Tags.Blocks.ORES).func_240534_a_((Object[])new Block[]{DEContent.ore_draconium_end, DEContent.ore_draconium_nether, DEContent.ore_draconium_overworld});
            this.func_240522_a_(BlockTags.field_232880_av_).func_240532_a_((Object)DEContent.infused_obsidian);
        }
    }

    private static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagProvider, modId, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_((ITag.INamedTag)DETags.Items.DUSTS_DRACONIUM).func_240532_a_((Object)DEContent.dust_draconium);
            this.func_240522_a_((ITag.INamedTag)DETags.Items.DUSTS_DRACONIUM_AWAKENED).func_240532_a_((Object)DEContent.dust_draconium_awakened);
            this.func_240522_a_((ITag.INamedTag)Tags.Items.DUSTS).addTags(new ITag.INamedTag[]{DETags.Items.DUSTS_DRACONIUM_AWAKENED, DETags.Items.DUSTS_DRACONIUM});
            this.func_240522_a_((ITag.INamedTag)DETags.Items.NUGGETS_DRACONIUM).func_240532_a_((Object)DEContent.nugget_draconium);
            this.func_240522_a_((ITag.INamedTag)DETags.Items.NUGGETS_DRACONIUM_AWAKENED).func_240532_a_((Object)DEContent.nugget_draconium_awakened);
            this.func_240522_a_((ITag.INamedTag)Tags.Items.NUGGETS).addTags(new ITag.INamedTag[]{DETags.Items.NUGGETS_DRACONIUM_AWAKENED, DETags.Items.NUGGETS_DRACONIUM});
            this.func_240522_a_((ITag.INamedTag)DETags.Items.INGOTS_DRACONIUM).func_240532_a_((Object)DEContent.ingot_draconium);
            this.func_240522_a_((ITag.INamedTag)DETags.Items.INGOTS_DRACONIUM_AWAKENED).func_240532_a_((Object)DEContent.ingot_draconium_awakened);
            this.func_240522_a_((ITag.INamedTag)Tags.Items.INGOTS).addTags(new ITag.INamedTag[]{DETags.Items.INGOTS_DRACONIUM_AWAKENED, DETags.Items.INGOTS_DRACONIUM});
            this.func_240522_a_((ITag.INamedTag)DETags.Items.STORAGE_BLOCKS_DRACONIUM).func_240532_a_((Object)DEContent.block_draconium.func_199767_j());
            this.func_240522_a_((ITag.INamedTag)DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED).func_240532_a_((Object)DEContent.block_draconium_awakened.func_199767_j());
            this.func_240522_a_((ITag.INamedTag)Tags.Items.STORAGE_BLOCKS).addTags(new ITag.INamedTag[]{DETags.Items.STORAGE_BLOCKS_DRACONIUM, DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED});
            this.func_240522_a_((ITag.INamedTag)DETags.Items.ORES_DRACONIUM).func_240534_a_((Object[])new Item[]{DEContent.ore_draconium_end.func_199767_j(), DEContent.ore_draconium_nether.func_199767_j(), DEContent.ore_draconium_overworld.func_199767_j()});
            this.func_240522_a_((ITag.INamedTag)Tags.Items.ORES).func_240531_a_(DETags.Items.ORES_DRACONIUM);
            if (ModList.get().isLoaded("curios")) {
                CuriosIntegration.generateTags(arg_0 -> ((ItemTagGenerator)this).func_240522_a_(arg_0));
            }
        }
    }
}

