/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.reactor.ProcessExplosion;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class CommandKaboom {
    private static ProcessExplosion explosionProcess = null;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"de_kaboom").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)10, (int)50000)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"position", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> CommandKaboom.calculate((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), false, true))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"effect_only").executes(ctx -> CommandKaboom.effect((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), false))).then(Commands.func_197057_a((String)"flash").executes(ctx -> CommandKaboom.effect((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), true))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"prime").executes(ctx -> CommandKaboom.calculate((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), true, true))).then(Commands.func_197057_a((String)"no_effect").executes(ctx -> CommandKaboom.calculate((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), true, false))))).then(Commands.func_197057_a((String)"no_effect").executes(ctx -> CommandKaboom.calculate((CommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), (Vector3i)BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"position"), false, false)))))).then(Commands.func_197057_a((String)"detonate").executes(ctx -> CommandKaboom.detonate()))).then(Commands.func_197057_a((String)"abort").executes(ctx -> CommandKaboom.abort((CommandContext<CommandSource>)ctx))));
    }

    private static int calculate(CommandSource source, int radius, Vector3i pos, boolean prime, boolean effect) {
        if (explosionProcess != null && !explosionProcess.isDead()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Explosion already in progress"));
            return 1;
        }
        LogHelper.dev("calculate Rad: " + radius + ", Pos: " + pos + ", Prime: " + prime);
        explosionProcess = new ProcessExplosion(new BlockPos(pos), radius, source.func_197023_e(), prime ? -1 : 0);
        CommandKaboom.explosionProcess.enableEffect = effect;
        CommandKaboom.explosionProcess.progressMon = progress -> {
            if (TimeKeeper.getServerTick() % 20 == 0) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Calculating: " + Math.round(progress * 100.0) + "%"), true);
            }
        };
        ProcessHandler.addProcess((IProcess)explosionProcess);
        return 0;
    }

    private static int effect(CommandSource source, int radius, Vector3i pos, boolean flash) {
        if (flash) {
            ClientEventHandler.triggerExplosionEffect(new BlockPos(pos));
        } else {
            DraconicNetwork.sendExplosionEffect((RegistryKey<World>)source.func_197023_e().func_234923_W_(), new BlockPos(pos), radius, false);
        }
        return 0;
    }

    private static int detonate() {
        WorldEntityHandler.getWorldEntities().forEach(WorldEntity::removeEntity);
        if (explosionProcess != null && explosionProcess.isCalculationComplete()) {
            explosionProcess.detonate();
            explosionProcess = null;
            return 0;
        }
        return 1;
    }

    private static int abort(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        if (explosionProcess != null) {
            CommandKaboom.explosionProcess.isDead = true;
            explosionProcess = null;
            return 0;
        }
        return 1;
    }

    private static int relight(CommandSource source) {
        BlockPos pos = new BlockPos(source.func_197036_d());
        ServerWorld world = source.func_197023_e();
        while (world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-10, -10, -10), (BlockPos)pos.func_177982_a(10, 10, 10)).forEach(e -> {
            world.func_225524_e_().func_215568_a(e);
            Chunk chunk = world.func_175726_f(e);
        });
        return 0;
    }
}

