/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class ToolRenderBase
implements IItemRenderer {
    public static ShaderProgram chaosShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/chaos.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/chaos.frag")).uniform("alpha", UniformType.FLOAT).uniform("yaw", UniformType.FLOAT).uniform("pitch", UniformType.FLOAT).uniform("time", UniformType.FLOAT)).whenUsed(cache -> {
        cache.glUniform1f("alpha", 0.7f);
        Minecraft mc = Minecraft.func_71410_x();
        cache.glUniform1f("yaw", (float)((double)(mc.field_71439_g.field_70177_z * 2.0f) * Math.PI / 360.0));
        cache.glUniform1f("pitch", -((float)((double)(mc.field_71439_g.field_70125_A * 2.0f) * Math.PI / 360.0)));
        cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 1.0f);
    }).build();
    public static ShaderProgram gemShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/tool_gem.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    public static ShaderProgram bladeShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/tool_blade.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    public static ShaderProgram traceShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/tool_trace.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC4)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    public RenderType modelType;
    public RenderType modelGuiType;
    public RenderType chaosType;
    public RenderType shaderParentType;
    public CCModel baseModel;
    public CCModel materialModel;
    public CCModel traceModel;
    public CCModel bladeModel;
    public CCModel gemModel;
    public VBORenderType baseVBOType;
    public VBORenderType guiBaseVBOType;
    public VBORenderType materialVBOType;
    public VBORenderType materialChaosVBOType;
    public VBORenderType guiMaterialVBOType;
    public VBORenderType traceVBOType;
    public VBORenderType bladeVBOType;
    public VBORenderType gemVBOType;
    public TechLevel techLevel;
    protected static float[][] baseColours = new float[][]{{0.0f, 0.5f, 0.8f, 1.0f}, {0.55f, 0.0f, 0.65f, 1.0f}, {0.8f, 0.5f, 0.1f, 1.0f}, {0.75f, 0.05f, 0.05f, 0.2f}};

    public ToolRenderBase(TechLevel techLevel, String tool) {
        this.techLevel = techLevel;
        String levelName = techLevel.name().toLowerCase(Locale.ENGLISH);
        this.modelType = RenderType.func_228633_a_((String)"modelType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/" + levelName + "_" + tool + ".png"), false, false)).func_228716_a_(RenderState.field_228532_x_).func_228719_a_(RenderState.field_228528_t_).func_228728_a_(true));
        this.modelGuiType = RenderType.func_228632_a_((String)"modelGuiType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/" + levelName + "_" + tool + ".png"), false, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228531_w_).func_228728_a_(false));
        this.chaosType = RenderType.func_228632_a_((String)"chaosShaderType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/chaos_shader.png"), true, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228530_v_).func_228728_a_(false));
        this.shaderParentType = RenderType.func_228632_a_((String)"shaderGemType", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)4, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/item/equipment/shader_fallback_" + levelName + ".png"), false, false)).func_228719_a_(RenderState.field_228528_t_).func_228722_a_(RenderState.field_228530_v_).func_228728_a_(false));
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = 240;
        ccrs.overlay = packedOverlay;
        this.renderTool(ccrs, stack, transformType, mat, mStack, getter, transformType == ItemCameraTransforms.TransformType.GUI, packedLight);
    }

    public abstract void renderTool(CCRenderState var1, ItemStack var2, ItemCameraTransforms.TransformType var3, Matrix4 var4, MatrixStack var5, IRenderTypeBuffer var6, boolean var7, int var8);

    public void transform(Matrix4 mat, double x, double y, double z, double scale) {
        mat.translate(x, y, z);
        mat.rotate(1.5707963267948701, Vector3.Y_NEG);
        mat.rotate(0.7853981633974351, Vector3.X_POS);
        mat.scale(scale);
    }

    public IModelTransform getModelTransform() {
        return TransformUtils.DEFAULT_TOOL;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public static ShaderRenderType getShaderType(RenderType parent, TechLevel techLevel, ShaderProgram shader) {
        return ToolRenderBase.getShaderType(parent, techLevel, shader, 1.0f);
    }

    public static ShaderRenderType getShaderType(RenderType parent, TechLevel techLevel, ShaderProgram shader, float pulse) {
        UniformCache uniforms = shader.pushCache();
        float[] baseColour = baseColours[techLevel.index];
        float r = baseColour[0];
        float g = baseColour[1];
        float b = baseColour[2];
        float a = baseColour[3];
        switch (techLevel) {
            case DRACONIUM: {
                a *= 1.0f + pulse;
                break;
            }
            case WYVERN: {
                a *= 1.0f + pulse;
                break;
            }
            case DRACONIC: {
                a *= 1.0f + pulse;
                break;
            }
            case CHAOTIC: {
                r += pulse * 0.2f;
                g += pulse * 0.2f;
                b += pulse * 0.2f;
            }
        }
        uniforms.glUniform4f("baseColour", r, g, b, a);
        return new ShaderRenderType(parent, shader, uniforms);
    }

    public static ShaderRenderType getShaderType(RenderType parent, ShaderProgram shader) {
        return new ShaderRenderType(parent, shader, shader.pushCache());
    }

    public void initBaseVBO() {
        this.baseVBOType = new VBORenderType(this.modelType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.baseModel.render(ccrs, new IVertexOperation[0]);
        });
        this.guiBaseVBOType = new VBORenderType(this.modelGuiType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.baseModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    public void initMaterialVBO() {
        this.materialVBOType = new VBORenderType(this.modelType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialModel.render(ccrs, new IVertexOperation[0]);
        });
        this.guiMaterialVBOType = new VBORenderType(this.modelGuiType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialModel.render(ccrs, new IVertexOperation[0]);
        });
        this.materialChaosVBOType = new VBORenderType(this.chaosType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.materialModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    public void initTraceVBO() {
        this.traceVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.traceModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    public void initBladeVBO() {
        this.bladeVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.bladeModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    public void initGemVBO() {
        this.gemVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.gemModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    @Deprecated
    public static void endBatch(IRenderTypeBuffer getter) {
        if (getter instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)getter).func_228461_a_();
        }
    }
}

