/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderLootCore
extends EntityRenderer<EntityLootCore> {
    public RenderLootCore(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityLootCore entity, double x, double y, double z, float entityYaw, float partialTicks) {
        ResourceHelperDE.bindTexture("textures/items/loot_core.png");
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        float yOffset = MathHelper.func_76126_a((float)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 10.0f)) * 0.1f + 0.1f;
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3(x, y + (double)(entity.func_213302_cg() / 2.0f) + (double)yOffset, z), (Rotation)new Rotation((double)(((float)(ClientEventHandler.elapsedTicks + entity.timeOffset) + partialTicks) / 30.0f), new Vector3(entity.rotX, entity.rotY, 0.0).normalize()), (double)0.1);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.draw();
        boolean bl = entity.isLooking = Minecraft.func_71410_x().func_175598_ae().field_147941_i == entity;
        if (entity.lookAnimation > 0.0f) {
            // empty if block
        }
    }

    public void renderLabel(EntityLootCore lootCore, FontRenderer renderer, float x, float y, float z, float viewY, float viewX, boolean thirdPerson) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)z);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(-viewY), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)((float)(thirdPerson ? -1 : 1) * viewX), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        RenderSystem.disableLighting();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int rows = lootCore.displayMap.size();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double scale = lootCore.lookAnimation;
        double heightScale = Math.min(scale * 2.0, 1.0);
        double widthScale = Math.max((scale - 0.5) * 2.0, 0.0);
        double height = (double)(rows * 8) * heightScale + 1.0;
        double width = widthScale * 40.0;
        double xPos = 10.0 - width / 2.0;
        double yPos = -4.0 - height / 2.0;
        this.renderBox(vertexbuffer, xPos - 1.0, yPos, 1.0, height, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos + width, yPos, 1.0, height, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos - 1.0, yPos - 1.0, width + 2.0, 1.0, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos - 1.0, yPos + height, width + 2.0, 1.0, 0x60AAAAAA);
        this.renderBox(vertexbuffer, xPos, yPos, width, height, 0x60000000);
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        if (lootCore.lookAnimation >= 1.0f) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)-5.0, (double)0.0, (double)0.0);
            RenderSystem.scaled((double)9.0, (double)9.0, (double)9.0);
            RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.popMatrix();
            String name = I18n.func_135052_a((String)"entity.draconicevolution:lootCore.name", (Object[])new Object[0]);
            int w = renderer.func_78256_a(name);
            renderer.func_238421_b_(new MatrixStack(), name, 11.0f - (float)w / 2.0f, (float)((int)yPos - 10), -1);
            int row = 0;
            for (ItemStack stack : lootCore.displayMap.keySet()) {
                int rowY = (int)yPos + row * 8 + 4;
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)-5.0, (double)rowY, (double)0.0);
                RenderSystem.scaled((double)9.0, (double)9.0, (double)9.0);
                RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderSystem.popMatrix();
                renderer.func_238421_b_(new MatrixStack(), "x" + lootCore.displayMap.get(stack), 0.0f, (float)(-4 + rowY), -1);
                ++row;
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    private void renderBox(BufferBuilder buffer, double x, double y, double width, double height, int colour) {
        ColourARGB colourARGB = new ColourARGB(colour);
        double zLevel = 0.0;
        buffer.func_225582_a_(x, y + height, zLevel).func_227885_a_((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_225582_a_(x + width, y + height, zLevel).func_227885_a_((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_225582_a_(x + width, y, zLevel).func_227885_a_((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
        buffer.func_225582_a_(x, y, zLevel).func_227885_a_((float)colourARGB.r / 255.0f, (float)colourARGB.g / 255.0f, (float)colourARGB.b / 255.0f, (float)colourARGB.a / 255.0f).func_181675_d();
    }

    public ResourceLocation getTextureLocation(EntityLootCore entity) {
        return ResourceHelperDE.getResource("textures/items/loot_core.png");
    }
}

