/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.draconicevolution.DEConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class ItemConfigDataHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompoundNBT retrieveData() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            ServerWorld world = mc.func_71401_C().func_71218_a(World.field_234918_g_);
            SinglePlayerWorldData data = (SinglePlayerWorldData)world.func_217481_x().func_215752_a(SinglePlayerWorldData::new, "draconic_item_config");
            return data.data;
        }
        Path file = Paths.get("./config/brandon3055/servers/" + DEConfig.serverID + ".dat", new String[0]);
        if (!Files.exists(file, new LinkOption[0])) return new CompoundNBT();
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)is);
            return compoundNBT;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CompoundNBT();
    }

    public static void saveData(CompoundNBT nbt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            ServerWorld world = mc.func_71401_C().func_71218_a(World.field_234918_g_);
            SinglePlayerWorldData data = (SinglePlayerWorldData)world.func_217481_x().func_215752_a(SinglePlayerWorldData::new, "draconic_item_config");
            data.data = nbt;
            data.func_76185_a();
        } else {
            Path file = Paths.get("./config/brandon3055/servers/" + DEConfig.serverID + ".dat", new String[0]);
            if (Files.notExists(file, new LinkOption[0])) {
                SneakyUtils.sneaky(() -> Files.createDirectories(file.getParent(), new FileAttribute[0]));
            } else {
                SneakyUtils.sneaky(() -> Files.delete(file));
            }
            try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SinglePlayerWorldData
    extends WorldSavedData {
        private CompoundNBT data = new CompoundNBT();

        public SinglePlayerWorldData() {
            super("draconic_item_config");
        }

        public void func_76184_a(CompoundNBT nbt) {
            this.data = nbt;
        }

        public CompoundNBT func_189551_b(CompoundNBT compound) {
            return this.data;
        }
    }
}

