/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.ThemedElements;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleItem;
import com.brandon3055.draconicevolution.client.ClientProxy;
import com.brandon3055.draconicevolution.client.ModuleSpriteUploader;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class ModuleGridRenderer
extends GuiElement<ModuleGridRenderer> {
    private static final RenderType moduleType = RenderType.func_228632_a_((String)"module_type", (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(ModuleSpriteUploader.LOCATION_MODULE_TEXTURE, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228728_a_(false));
    private ModuleGrid grid;
    private PlayerInventory player;
    private boolean doubleClick;
    private long lastClickTime;
    private int lastClickButton;
    private boolean canDrop = false;
    private ModuleGrid.GridPos lastClickPos;
    private ITextComponent lastError = null;
    private int lastErrorTime = 0;
    private ModuleGrid.GridPos hoverCell = null;
    private int hoverTime = 0;

    public ModuleGridRenderer(ModuleGrid grid, PlayerInventory player) {
        this.grid = grid;
        this.player = player;
        this.setSize(grid.getWidth() * grid.getCellSize(), grid.getHeight() * grid.getCellSize());
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int light = ThemedElements.getBgLight();
        int dark = ThemedElements.getBgDark();
        int fill = ThemedElements.getBgFill();
        this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos() - 2, this.yPos() - 2, this.xSize() + 4, this.ySize() + 4, 1.0, 0, light, dark, fill);
        this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos() - 1, this.yPos() - 1, this.xSize() + 2, this.ySize() + 2, 1.0, 0, dark, light, fill);
        this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), ModuleGridRenderer.midColour((int)light, (int)dark));
        int s = this.grid.getCellSize();
        for (int x = 0; x < this.grid.getWidth(); ++x) {
            for (int y = 0; y < this.grid.getHeight(); ++y) {
                int xPos = this.xPos() + x * s;
                int yPos = this.yPos() + y * s;
                this.renderCell((IRenderTypeBuffer)getter, xPos, yPos, s, x, y, mouseX, mouseY, GuiHelperOld.isInRect((int)xPos, (int)yPos, (int)s, (int)s, (double)mouseX, (double)mouseY), partialTicks);
            }
        }
        getter.func_228461_a_();
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.player.func_70445_o().func_190926_b()) {
                this.renderCellOverlay(mouseX, mouseY);
            } else if (this.lastError != null) {
                this.drawHoveringTextString(Collections.singletonList(this.lastError.getString()), mouseX, mouseY, (FontRenderer)this.fontRenderer);
            }
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void renderCell(IRenderTypeBuffer getter, int x, int y, int size, int cellX, int cellY, double mouseX, double mouseY, boolean mouseOver, float partialTicks) {
        ModuleGrid.GridPos cell = this.grid.getCell(cellX, cellY);
        if (cell.hasEntity()) {
            ModuleEntity entity = cell.getEntity();
            int cs = this.grid.getCellSize();
            if (cell.isActualEntityPos()) {
                this.drawModule(getter, x, y, entity.getModule());
            }
            if (mouseOver) {
                this.drawColouredRect(getter, this.xPos() + entity.getGridX() * cs, this.yPos() + entity.getGridY() * cs, cell.getEntity().getWidth() * cs, cell.getEntity().getHeight() * cs, 0x50FFFFFF);
            }
            entity.renderSlotOverlay(getter, this.mc, this.xPos() + entity.getGridX() * cs, this.yPos() + entity.getGridY() * cs, cell.getEntity().getWidth() * cs, cell.getEntity().getHeight() * cs, mouseX, mouseY, mouseOver, partialTicks);
        } else {
            this.drawColouredRect(getter, x + 1, y + 1, size - 2, size - 2, BCConfig.darkMode ? -8355712 : -11513776);
            if (mouseOver) {
                this.drawColouredRect(getter, x, y, size, size, 0x50FFFFFF);
            }
        }
    }

    public void renderCellOverlay(int mouseX, int mouseY) {
        ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, false);
        if (cell.hasEntity() && this.hoverTime > 10) {
            Item item = cell.getEntity().getModule().getItem();
            ItemStack stack = new ItemStack((IItemProvider)item);
            cell.getEntity().writeToItemStack(stack, this.grid.container.getModuleContext());
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            if (font == null) {
                font = this.fontRenderer;
            }
            List list = this.getTooltipFromItem(stack);
            this.drawHoveringText(list, mouseX, mouseY, font);
        }
    }

    public boolean renderStackOverride(ItemStack stack, int x, int y, String altText) {
        Module<?> module;
        if (this.isMouseOver((x += 8) + this.modularGui.guiLeft(), (y += 8) + this.modularGui.guiTop()) && (module = ModuleItem.getModule(stack)) != null) {
            int cs = this.grid.getCellSize();
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            this.drawModule((IRenderTypeBuffer)getter, x - mw / 2, y - mh / 2, module);
            getter.func_228461_a_();
            if (stack.func_190916_E() > 1 || altText != null) {
                this.zOffset += 250.0;
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                if (font == null) {
                    font = this.fontRenderer;
                }
                String s = altText == null ? String.valueOf(stack.func_190916_E()) : altText;
                MatrixStack matrixStack = new MatrixStack();
                float f = (float)(x - font.func_78256_a(s)) + (float)mw / 2.0f - 1.0f;
                font.getClass();
                font.func_238405_a_(matrixStack, s, f, (float)(y - 9) + (float)mh / 2.0f, 0xFFFFFF);
                this.zOffset -= 250.0;
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.canDrop = false;
        this.lastError = null;
        if (this.isMouseOver(mouseX, mouseY)) {
            InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(button);
            boolean pickBlock = this.mc.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
            ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
            long i = Util.func_211177_b();
            boolean bl = this.doubleClick = i - this.lastClickTime < 250L && this.lastClickButton == button && this.getCellAtPos(mouseX, mouseY, false).equals(this.lastClickPos);
            if ((button == 0 || pickBlock) && cell.isValidCell()) {
                if (this.player.func_70445_o().func_190926_b()) {
                    if (pickBlock) {
                        this.handleGridClick(cell, button, ClickType.CLONE);
                    } else {
                        boolean shiftClick = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
                        ClickType clicktype = ClickType.PICKUP;
                        if (shiftClick) {
                            clicktype = ClickType.QUICK_MOVE;
                        }
                        this.handleGridClick(cell, button, clicktype);
                    }
                } else {
                    this.canDrop = true;
                }
            }
            this.lastClickTime = i;
            this.lastClickPos = this.getCellAtPos(mouseX, mouseY, false);
            this.lastClickButton = button;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        ModuleGrid.GridPos cell = this.getCellAtPos(mouseX, mouseY, true);
        if (this.doubleClick && button == 0) {
            this.handleGridClick(cell, button, ClickType.PICKUP_ALL);
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else if (this.canDrop && button == 0) {
            this.handleGridClick(cell, button, ClickType.PICKUP);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void handleGridClick(ModuleGrid.GridPos cell, int mouseButton, ClickType type) {
        DraconicNetwork.sendModuleContainerClick(cell, mouseButton, type);
        InstallResult result = this.grid.cellClicked(cell, mouseButton, type);
        if (result != null && result.resultType != InstallResult.InstallResultType.YES && result.resultType != InstallResult.InstallResultType.OVERRIDE) {
            this.lastError = result.reason;
            this.lastErrorTime = 0;
        }
    }

    private ModuleGrid.GridPos getCellAtPos(double xPos, double yPos, boolean withPlaceOffset) {
        int cs = this.grid.getCellSize();
        int x = (int)((xPos - (double)this.xPos()) / (double)cs);
        int y = (int)((yPos - (double)this.yPos()) / (double)cs);
        Module<?> module = ModuleItem.getModule(this.player.func_70445_o());
        if (module != null && withPlaceOffset) {
            int mw = module.getProperties().getWidth() * cs;
            int mh = module.getProperties().getHeight() * cs;
            x = (int)((xPos - (double)this.xPos() - (double)mw / 2.0 + (double)cs / 2.0) / (double)cs);
            y = (int)((yPos - (double)this.yPos() - (double)mh / 2.0 + (double)cs / 2.0) / (double)cs);
        }
        return this.grid.getCell(x, y);
    }

    private void drawModule(IRenderTypeBuffer getter, int x, int y, Module<?> module) {
        int cs = this.grid.getCellSize();
        int mw = module.getProperties().getWidth() * cs;
        int mh = module.getProperties().getHeight() * cs;
        int colour = this.getModuleColour(module);
        this.drawColouredRect(getter, x, y, mw, mh, colour);
        this.drawBorderedRect(getter, x, y, mw, mh, 1.0, 0, ModuleGridRenderer.mixColours((int)colour, (int)0x20202000, (boolean)true));
        if (module.getProperties().getTechLevel() == TechLevel.CHAOTIC) {
            IVertexBuilder builder = getter.getBuffer(RenderType.func_228653_j_());
            float zLevel = this.getRenderZLevel();
            builder.func_225582_a_((double)x, (double)(y + mh), (double)zLevel).func_225583_a_(0.0f, (float)mh / (float)mw / 64.0f).func_181675_d();
            builder.func_225582_a_((double)(x + mw), (double)(y + mh), (double)zLevel).func_225583_a_((float)mw / (float)mh / 64.0f, (float)mh / (float)mw / 64.0f).func_181675_d();
            builder.func_225582_a_((double)(x + mw), (double)y, (double)zLevel).func_225583_a_((float)mw / (float)mh / 64.0f, 0.0f).func_181675_d();
            builder.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
            ToolRenderBase.endBatch(getter);
        }
        TextureAtlasSprite sprite = ClientProxy.moduleSpriteUploader.getSprite(module);
        float ar = (float)sprite.func_94211_a() / (float)sprite.func_94216_b();
        float iar = (float)sprite.func_94216_b() / (float)sprite.func_94211_a();
        IVertexBuilder builder = getter.getBuffer(moduleType);
        if (iar * (float)mw <= (float)mh) {
            double height = (float)mw * iar;
            this.bufferSprite(builder, sprite, x, (double)y + (double)mh / 2.0 - height / 2.0, mw, height);
        } else {
            double width = (float)mh * ar;
            this.bufferSprite(builder, sprite, (double)x + (double)mw / 2.0 - width / 2.0, y, width, mh);
        }
    }

    private void bufferSprite(IVertexBuilder builder, TextureAtlasSprite sprite, double x, double y, double width, double height) {
        builder.func_225582_a_(x, y + height, this.zOffset).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y + height, this.zOffset).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        builder.func_225582_a_(x + width, y, this.zOffset).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        builder.func_225582_a_(x, y, this.zOffset).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
    }

    public boolean onUpdate() {
        ModuleGrid.GridPos cell = this.getCellAtPos(this.getMouseX(), this.getMouseY(), false);
        if (cell.hasEntity()) {
            if (cell.equals(this.hoverCell)) {
                ++this.hoverTime;
            } else {
                this.hoverTime = 0;
                this.hoverCell = cell;
            }
        } else {
            this.hoverTime = 0;
        }
        this.grid.container.clientTick();
        if (this.lastError != null && this.lastErrorTime++ > 100) {
            this.lastError = null;
        }
        return super.onUpdate();
    }

    private int getModuleColour(Module<?> module) {
        switch (module.getProperties().getTechLevel()) {
            case DRACONIUM: {
                return -14793322;
            }
            case WYVERN: {
                return -12839599;
            }
            case DRACONIC: {
                return -3462656;
            }
            case CHAOTIC: {
                return -15658735;
            }
        }
        return 0;
    }
}

