/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.texture.IIconRegister;
import codechicken.lib.texture.SpriteRegistryHelper;
import codechicken.lib.util.ResourceUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.draconicevolution.CommonProxy;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DESprites;
import com.brandon3055.draconicevolution.client.DETextures;
import com.brandon3055.draconicevolution.client.ModuleSpriteUploader;
import com.brandon3055.draconicevolution.client.gui.GuiDraconiumChest;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyTransfuser;
import com.brandon3055.draconicevolution.client.gui.GuiFlowGate;
import com.brandon3055.draconicevolution.client.gui.GuiFusionCraftingCore;
import com.brandon3055.draconicevolution.client.gui.GuiGenerator;
import com.brandon3055.draconicevolution.client.gui.GuiGrinder;
import com.brandon3055.draconicevolution.client.gui.GuiReactor;
import com.brandon3055.draconicevolution.client.gui.modular.GuiModularItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.StaffRenderEventHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.model.ModularArmorModel;
import com.brandon3055.draconicevolution.client.model.VBOArmorLayer;
import com.brandon3055.draconicevolution.client.render.effect.ExplosionFX;
import com.brandon3055.draconicevolution.client.render.effect.ReactorBeamFX;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianProjectileRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianWitherRenderer;
import com.brandon3055.draconicevolution.client.render.entity.projectile.DraconicArrowRenderer;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.client.render.item.RenderItemChaosShard;
import com.brandon3055.draconicevolution.client.render.item.RenderItemDraconiumChest;
import com.brandon3055.draconicevolution.client.render.item.RenderItemEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.item.RenderItemMobSoul;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorPart;
import com.brandon3055.draconicevolution.client.render.item.RenderModularAxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularBow;
import com.brandon3055.draconicevolution.client.render.item.RenderModularChestpeice;
import com.brandon3055.draconicevolution.client.render.item.RenderModularHoe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularPickaxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularShovel;
import com.brandon3055.draconicevolution.client.render.item.RenderModularStaff;
import com.brandon3055.draconicevolution.client.render.item.RenderModularSword;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.render.tile.DraconiumChestTileRenderer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileChaosCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCraftingInjector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDislocatorPedestal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileECStabilizer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyPylon;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyTransfuser;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGenerator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGrinder;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePotentiometer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileStabilizedSpawner;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.FusionTileFXHandler;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.ITileFXHandler;
import com.brandon3055.draconicevolution.client.sound.GeneratorSoundHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

public class ClientProxy
extends CommonProxy {
    public static SpriteRegistryHelper spriteHelper = new SpriteRegistryHelper();
    public static ModelRegistryHelper modelHelper = new ModelRegistryHelper();
    public static ModuleSpriteUploader moduleSpriteUploader;
    public static ShieldHudElement hudElement;

    @Override
    public void construct() {
        super.construct();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            moduleSpriteUploader = new ModuleSpriteUploader();
        });
        spriteHelper.addIIconRegister((IIconRegister)new DETextures());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DESprites::initialize);
        StaffRenderEventHandler.init();
        CustomBossInfoHandler.init();
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(AbstractHudElement.class, this::registerHudElements);
        MinecraftForge.EVENT_BUS.addListener(this::registerShaderReloads);
    }

    @Override
    public void commonSetup(FMLCommonSetupEvent event) {
        super.commonSetup(event);
    }

    @Override
    public void clientSetup(FMLClientSetupEvent event) {
        super.clientSetup(event);
        this.registerGuiFactories();
        this.registerItemRenderers();
        this.registerTileRenderers();
        this.registerEntityRendering();
        this.setupRenderLayers();
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        KeyBindings.init();
        ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)new DETextures());
        event.enqueueWork(() -> {
            for (EntityRenderer e : Minecraft.func_71410_x().func_175598_ae().field_78729_o.values()) {
                if (!(e instanceof LivingRenderer) || !(((LivingRenderer)e).func_217764_d() instanceof BipedModel)) continue;
                boolean foundArmor = false;
                for (Object layer : ((LivingRenderer)e).field_177097_h) {
                    if (!(layer instanceof BipedArmorLayer)) continue;
                    ((LivingRenderer)e).func_177094_a(new VBOArmorLayer((LivingRenderer)e, (BipedArmorLayer)layer));
                    foundArmor = true;
                    break;
                }
                if (foundArmor) continue;
                ((LivingRenderer)e).func_177094_a(new VBOArmorLayer((LivingRenderer)e, null));
            }
            for (PlayerRenderer renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
                renderPlayer.func_177094_a(new VBOArmorLayer(renderPlayer, null));
                renderPlayer.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)renderPlayer){

                    public boolean shouldRender(ItemStack stack, LivingEntity entity) {
                        return stack.func_77973_b() instanceof IModularArmor && stack.canElytraFly(entity);
                    }
                });
            }
        });
    }

    private void registerShaderReloads(ParticleFactoryRegisterEvent event) {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        if (DEConfig.guardianShaders) {
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)CustomBossInfoHandler.shieldShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)DraconicGuardianRenderer.shieldShader);
        }
        if (DEConfig.crystalShaders) {
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderItemEnergyCrystal.crystalShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderTileEnergyCrystal.crystalShader);
        }
        if (DEConfig.toolShaders) {
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderModularBow.stringShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ModularArmorModel.shieldShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderModularChestpeice.coreShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ToolRenderBase.chaosShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ToolRenderBase.gemShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ToolRenderBase.bladeShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ToolRenderBase.traceShader);
        }
        if (DEConfig.reactorShaders) {
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ExplosionFX.blastWaveProgram);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ExplosionFX.coreEffectProgram);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ExplosionFX.leadingWaveProgram);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ReactorBeamFX.beamShaderE);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ReactorBeamFX.beamShaderI);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ReactorBeamFX.beamShaderO);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)ClientEventHandler.explosionShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderTileReactorCore.coreShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderTileReactorCore.shieldShader);
        }
        if (DEConfig.otherShaders) {
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderTileChaosCrystal.chaosShader);
            ResourceUtils.registerReloadListener((ISelectiveResourceReloadListener)RenderTileChaosCrystal.shieldShader);
        }
    }

    private void registerGuiFactories() {
        ScreenManager.func_216911_a(DEContent.container_generator, GuiGenerator::new);
        ScreenManager.func_216911_a(DEContent.container_grinder, GuiGrinder::new);
        ScreenManager.func_216911_a(DEContent.container_draconium_chest, GuiDraconiumChest::new);
        ScreenManager.func_216911_a(DEContent.container_energy_core, GuiEnergyCore::new);
        ScreenManager.func_216911_a(DEContent.container_modular_item, GuiModularItem::new);
        ScreenManager.func_216911_a(DEContent.container_configurable_item, GuiConfigurableItem::new);
        ScreenManager.func_216911_a(DEContent.container_reactor, GuiReactor::new);
        ScreenManager.func_216911_a(DEContent.container_fusion_crafting_core, GuiFusionCraftingCore::new);
        ScreenManager.func_216911_a(DEContent.container_flow_gate, GuiFlowGate::new);
        ScreenManager.func_216911_a(DEContent.container_energy_transfuser, GuiEnergyTransfuser::new);
    }

    private void registerTileRenderers() {
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_grinder, RenderTileGrinder::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_draconium_chest, DraconiumChestTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_storage_core, RenderTileEnergyCore::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_energy_pylon, RenderTileEnergyPylon::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_core_stabilizer, RenderTileECStabilizer::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_stabilized_spawner, RenderTileStabilizedSpawner::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_generator, RenderTileGenerator::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_crystal_io, RenderTileEnergyCrystal::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_crystal_relay, RenderTileEnergyCrystal::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_crystal_wireless, RenderTileEnergyCrystal::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_reactor_core, RenderTileReactorCore::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_reactor_injector, RenderTileReactorComponent::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_reactor_stabilizer, RenderTileReactorComponent::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_crafting_core, RenderTileFusionCraftingCore::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_crafting_injector, RenderTileCraftingInjector::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_potentiometer, RenderTilePotentiometer::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_energy_transfuser, RenderTileEnergyTransfuser::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_chaos_crystal, RenderTileChaosCrystal::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_dislocator_pedestal, RenderTileDislocatorPedestal::new);
        ClientRegistry.bindTileEntityRenderer(DEContent.tile_placed_item, RenderTilePlacedItem::new);
    }

    private void registerItemRenderers() {
        modelHelper.register(new ModelResourceLocation(DEContent.chaos_shard.getRegistryName(), "inventory"), (IBakedModel)new RenderItemChaosShard(DEContent.chaos_shard));
        modelHelper.register(new ModelResourceLocation(DEContent.chaos_frag_large.getRegistryName(), "inventory"), (IBakedModel)new RenderItemChaosShard(DEContent.chaos_frag_large));
        modelHelper.register(new ModelResourceLocation(DEContent.chaos_frag_medium.getRegistryName(), "inventory"), (IBakedModel)new RenderItemChaosShard(DEContent.chaos_frag_medium));
        modelHelper.register(new ModelResourceLocation(DEContent.chaos_frag_small.getRegistryName(), "inventory"), (IBakedModel)new RenderItemChaosShard(DEContent.chaos_frag_small));
        modelHelper.register(new ModelResourceLocation(DEContent.mob_soul.getRegistryName(), "inventory"), (IBakedModel)new RenderItemMobSoul());
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_io_basic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIUM));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_io_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.WYVERN));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_io_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.CRYSTAL_IO, TechLevel.DRACONIC));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_relay_basic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIUM));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_relay_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.WYVERN));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_relay_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.RELAY, TechLevel.DRACONIC));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_wireless_basic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIUM));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_wireless_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.WYVERN));
        modelHelper.register(new ModelResourceLocation(DEContent.crystal_wireless_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderItemEnergyCrystal(EnergyCrystal.CrystalType.WIRELESS, TechLevel.DRACONIC));
        modelHelper.register(new ModelResourceLocation(DEContent.draconium_chest.getRegistryName(), "inventory"), (IBakedModel)new RenderItemDraconiumChest());
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_core.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorComponent(0));
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_stabilizer.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorComponent(1));
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_injector.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorComponent(2));
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_prt_stab_frame.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorPart());
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_prt_in_rotor.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorPart());
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_prt_out_rotor.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorPart());
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_prt_rotor_full.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorPart());
        modelHelper.register(new ModelResourceLocation(DEContent.reactor_prt_focus_ring.getRegistryName(), "inventory"), (IBakedModel)new RenderItemReactorPart());
        if (DEConfig.fancyToolModels) {
            modelHelper.register(new ModelResourceLocation(DEContent.pickaxe_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularPickaxe(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.pickaxe_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularPickaxe(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.pickaxe_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularPickaxe(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.axe_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularAxe(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.axe_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularAxe(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.axe_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularAxe(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.shovel_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularShovel(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.shovel_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularShovel(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.shovel_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularShovel(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.sword_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularSword(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.sword_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularSword(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.sword_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularSword(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.bow_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularBow(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.bow_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularBow(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.bow_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularBow(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.staff_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularStaff(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.staff_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularStaff(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.hoe_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularHoe(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.hoe_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularHoe(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.hoe_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularHoe(TechLevel.CHAOTIC));
            modelHelper.register(new ModelResourceLocation(DEContent.chestpiece_wyvern.getRegistryName(), "inventory"), (IBakedModel)new RenderModularChestpeice(TechLevel.WYVERN));
            modelHelper.register(new ModelResourceLocation(DEContent.chestpiece_draconic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularChestpeice(TechLevel.DRACONIC));
            modelHelper.register(new ModelResourceLocation(DEContent.chestpiece_chaotic.getRegistryName(), "inventory"), (IBakedModel)new RenderModularChestpeice(TechLevel.CHAOTIC));
        }
    }

    private void setupRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)DEContent.grinder, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)DEContent.generator, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)DEContent.energy_transfuser, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)DEContent.portal, (RenderType)RenderType.func_228643_e_());
    }

    @Override
    public void serverSetup(FMLDedicatedServerSetupEvent event) {
        super.serverSetup(event);
    }

    public void registerEntityRendering() {
        RenderingRegistry.registerEntityRenderingHandler(DEContent.draconicGuardian, DraconicGuardianRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DEContent.guardianProjectile, GuardianProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DEContent.guardianCrystal, GuardianCrystalRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DEContent.persistentItem, manager -> new ItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(DEContent.draconicArrow, DraconicArrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DEContent.guardianWither, GuardianWitherRenderer::new);
    }

    public void registerHudElements(RegistryEvent.Register<AbstractHudElement> event) {
        hudElement = new ShieldHudElement();
        event.getRegistry().register(hudElement.setRegistryName("shield_hud"));
    }

    @Override
    public ENetFXHandler createENetFXHandler(IENetEffectTile tile) {
        if (EffectiveSide.get().isServer()) {
            return super.createENetFXHandler(tile);
        }
        return tile.createClientFXHandler();
    }

    @Override
    public ReactorEffectHandler createReactorFXHandler(TileReactorCore tile) {
        if (EffectiveSide.get().isServer()) {
            return super.createReactorFXHandler(tile);
        }
        return new ReactorEffectHandler(tile);
    }

    @Override
    public ISidedTileHandler createGeneratorSoundHandler(TileGenerator tile) {
        return new GeneratorSoundHandler(tile);
    }

    @Override
    public ITileFXHandler createFusionFXHandler(TileFusionCraftingCore tile) {
        return new FusionTileFXHandler(tile);
    }

    static {
        hudElement = null;
    }
}

