/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.draconicevolution.blocks.machines.FlowGate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TileFlowGate
extends TileBCore
implements ITickableTileEntity,
IChangeListener,
INamedContainerProvider,
IInteractTile {
    protected long transferThisTick = 0L;
    public final ManagedLong minFlow = (ManagedLong)this.register((IManagedData)new ManagedLong("min_flow", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedLong maxFlow = (ManagedLong)this.register((IManagedData)new ManagedLong("max_flow", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedLong flowOverride = (ManagedLong)this.register((IManagedData)new ManagedLong("flow_override", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool flowOverridden = (ManagedBool)this.register((IManagedData)new ManagedBool("flow_overridden", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte rsSignal = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_signal", -1, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private Direction rotationCache = null;

    public TileFlowGate(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        super.tick();
        this.transferThisTick = 0L;
    }

    public abstract String getUnits();

    @OnlyIn(value=Dist.CLIENT)
    public void setMin(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setMax(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 1);
    }

    public long getFlow() {
        if (this.flowOverridden.get()) {
            return this.flowOverride.get();
        }
        if (this.rsSignal.get() == -1) {
            this.rsSignal.set((int)((byte)this.field_145850_b.func_175687_A(this.field_174879_c)));
        }
        return this.minFlow.get() + (long)((double)this.rsSignal.get() / 15.0 * (double)(this.maxFlow.get() - this.minFlow.get()));
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (this.flowOverridden.get()) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (id == 0) {
                this.minFlow.set((long)((int)l));
            } else if (id == 1) {
                this.maxFlow.set((long)((int)l));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public TileEntity getTarget() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getDirection()));
    }

    public TileEntity getSource() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getDirection().func_176734_d()));
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.rotationCache = null;
    }

    public Direction getDirection() {
        if (this.rotationCache == null) {
            this.rotationCache = (Direction)this.func_195044_w().func_177229_b((Property)FlowGate.FACING);
        }
        return this.rotationCache;
    }

    public void onNeighborChange(BlockPos neighbor) {
        this.rsSignal.set((int)((byte)this.field_145850_b.func_175687_A(this.field_174879_c)));
    }
}

