/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.chest;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.SmeltingLogic;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDraconiumChest
extends TileBCore
implements ITickableTileEntity,
IRSSwitchable,
INamedContainerProvider,
IInteractTile {
    public final ManagedInt colour = (ManagedInt)this.register((IManagedData)new ManagedInt("colour", 6553750, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedShort numPlayersUsing = (ManagedShort)this.register((IManagedData)new ManagedShort("num_players_using", new DataFlags[]{DataFlags.SYNC_TILE}));
    public float prevLidAngle;
    public float lidAngle;
    public TileItemStackHandler mainInventory = new TileItemStackHandler(260);
    public TileItemStackHandler craftingItems = new TileItemStackHandler(9);
    public TileItemStackHandler furnaceItems = new TileItemStackHandler(5);
    public TileItemStackHandler capacitorInv = new TileItemStackHandler(1);
    public OPStorage opStorage = new OPStorage(1000000L, 128000L, 0L);
    public SmeltingLogic smeltingLogic = new SmeltingLogic(this, (IItemHandlerModifiable)this.furnaceItems, (IItemHandler)this.mainInventory, this.opStorage);
    @Deprecated
    public TileItemStackHandler old_item_handler = new TileItemStackHandler(267);

    public TileDraconiumChest() {
        super(DEContent.tile_draconium_chest);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setManaged("main_inv", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.mainInventory, new Direction[0]).saveBoth();
        this.capManager.setInternalManaged("crafting_inv", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.craftingItems).saveBoth();
        this.capManager.setInternalManaged("furnace_inv", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.furnaceItems).saveBoth();
        this.capManager.setInternalManaged("energy_inv", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.capacitorInv).saveBoth();
        this.furnaceItems.setStackValidator(stack -> this.smeltingLogic.isSmeltable((ItemStack)stack));
        this.furnaceItems.setContentsChangeListener(e -> this.smeltingLogic.inputInventoryChanged());
        this.mainInventory.setContentsChangeListener(e -> this.smeltingLogic.outputInventoryChanged().scheduleAutoFeed());
        this.mainInventory.setStackValidator(DraconiumChest::isStackValid);
        this.capacitorInv.setStackValidator(EnergyUtils::isEnergyItem);
        this.smeltingLogic.setFeedSourceInv((IItemHandlerModifiable)this.mainInventory);
        this.installIOTracker(this.opStorage);
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.old_item_handler).saveBoth();
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        super.tick();
        if (!this.field_145850_b.func_201670_d()) {
            this.numPlayersUsing.set((short)this.getAccessingPlayers().size());
            boolean enabled = this.isTileEnabled();
            if (enabled && this.opStorage.getOPStored() < this.opStorage.getMaxOPStored() && !this.capacitorInv.getStackInSlot(0).func_190926_b()) {
                EnergyUtils.transferEnergy((ItemStack)this.capacitorInv.getStackInSlot(0), (IOPStorage)this.opStorage);
            }
            this.smeltingLogic.tick(enabled);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = (float)MathHelper.approachLinear((double)this.lidAngle, (double)(this.numPlayersUsing.get() > 0 ? 1.0 : 0.0), (double)0.1);
        if ((double)this.prevLidAngle >= 0.5 && (double)this.lidAngle < 0.5) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.prevLidAngle == 0.0f && this.lidAngle > 0.0f) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public ActionResultType onBlockUse(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return ActionResultType.SUCCESS;
    }

    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerDraconiumChest(DEContent.container_draconium_chest, currentWindowIndex, playerInventory, this);
    }

    public void writeExtraTileAndStack(CompoundNBT compound) {
        this.smeltingLogic.saveAdditionalNBT(compound);
        compound.func_74757_a("inv_migrated", true);
    }

    public void readExtraTileAndStack(CompoundNBT compound) {
        this.smeltingLogic.loadAdditionalNBT(compound);
        DraconicEvolution.LOGGER.info("readExtraTileAndStack");
        if (!compound.func_74764_b("inv_migrated")) {
            DraconicEvolution.LOGGER.info("Chest Not Migrated!");
            DraconicEvolution.LOGGER.info((Object)compound);
            for (int i = 0; i < this.old_item_handler.getSlots(); ++i) {
                ItemStack stack = this.old_item_handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (i <= 259) {
                    this.mainInventory.setStackInSlot(i, stack);
                } else if (i <= 264) {
                    this.furnaceItems.setStackInSlot(i - 260, stack);
                } else if (i == 265) {
                    this.capacitorInv.setStackInSlot(0, stack);
                } else if (i == 266) {
                    InventoryUtils.insertItem((IItemHandler)this.mainInventory, (ItemStack)stack, (boolean)false);
                }
                this.old_item_handler.setStackInSlot(i, ItemStack.field_190927_a);
            }
            if (compound.func_150297_b("CraftingItems", 9)) {
                DraconicEvolution.LOGGER.info("Migrating Crafting Items");
                ListNBT nbttaglist = compound.func_150295_c("CraftingItems", 10);
                DraconicEvolution.LOGGER.info((Object)nbttaglist);
                for (int i = 1; i < nbttaglist.size(); ++i) {
                    CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
                    DraconicEvolution.LOGGER.info((Object)nbttagcompound);
                    if (i >= this.craftingItems.getSlots()) continue;
                    this.craftingItems.setStackInSlot(i - 1, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
                }
            }
        }
    }
}

