/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.render.particle.ParticleStarSpark;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class TileEntityDetector
extends TileBCore
implements IInteractTile,
IRedstoneEmitter,
ITickableTileEntity {
    private final boolean advanced;
    public float hRot = 0.0f;
    public float yRot = 1.5707964f;
    public float lthRot = 0.0f;
    public float ltyRot = 0.0f;
    public final ManagedShort pulseRate = (ManagedShort)this.register((IManagedData)new ManagedShort("pulse_rate", 30, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedShort range = (ManagedShort)this.register((IManagedData)new ManagedShort("range", 10, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedByte rsMinDetection = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_min_detection", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedByte rsMaxDetection = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_max_detection", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedBool pulseRsMode = (ManagedBool)this.register((IManagedData)new ManagedBool("pulse_rs_mode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedByte outputStrength = (ManagedByte)this.register((IManagedData)new ManagedByte("output_strength", new DataFlags[]{DataFlags.SAVE_NBT}));
    private int pulseTimer = -1;
    private int pulseDuration = 0;
    public OPStorage opStorage = new OPStorage(512000L, 32000L, 0L);
    public EntityFilter entityFilter;
    public List<String> playerNames = new ArrayList<String>();
    private AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public TileEntityDetector() {
        super(DEContent.tile_entity_detector);
        this.advanced = false;
    }

    public TileEntityDetector(boolean advanced) {
        super(DEContent.tile_entity_detector);
        this.advanced = advanced;
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.entityFilter = new EntityFilter(true, FilterType.values());
        this.entityFilter.setDirtyHandler(() -> ((TileEntityDetector)this).func_70296_d());
        this.entityFilter.setupServerPacketHandling(() -> this.createClientBoundPacket(0), packet -> this.sendPacketToClients(this.getAccessingPlayers(), (PacketCustom)packet));
        this.entityFilter.setupClientPacketHandling(() -> this.createServerBoundPacket(0), packetCustom -> BrandonsCore.proxy.sendToServer(packetCustom));
        this.setClientSidePacketHandler(0, input -> this.entityFilter.receivePacketFromServer(input));
        this.setServerSidePacketHandler(0, (input, player) -> this.entityFilter.receivePacketFromClient(input));
        this.setSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.setItemSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            this.updateAnimation();
            return;
        }
        if (this.pulseTimer == -1) {
            this.pulseTimer = this.pulseRate.get();
        } else if (this.pulseTimer > 0) {
            --this.pulseTimer;
        } else if (this.pulseTimer <= 0) {
            if (this.opStorage.getEnergyStored() >= this.getPulseCost()) {
                this.pulseTimer = this.pulseRate.get();
                this.doScanPulse();
            } else {
                this.pulseTimer = 10;
            }
        }
        if (this.outputStrength.get() > 0 && this.pulseRsMode.get() && this.pulseDuration <= 0) {
            this.outputStrength.zero();
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        } else {
            --this.pulseDuration;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateAnimation() {
        List entities = this.entityFilter.filterEntities((Collection)this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)this.range.get(), (double)this.range.get(), (double)this.range.get())));
        Entity closest = null;
        double closestDist = -1.0;
        Vector3d posVec = new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        for (Entity entity : entities) {
            if (closest == null) {
                closest = entity;
                closestDist = entity.func_195048_a(posVec);
                continue;
            }
            if (!(entity.func_195048_a(posVec) < closestDist)) continue;
            closest = entity;
            closestDist = entity.func_195048_a(posVec);
        }
        this.lthRot = this.hRot;
        this.ltyRot = this.yRot;
        if (closest != null) {
            double xDist = closest.func_226277_ct_() - (double)((float)this.func_174877_v().func_177958_n() + 0.5f);
            double zDist = closest.func_226281_cx_() - (double)((float)this.func_174877_v().func_177952_p() + 0.5f);
            double yDist = closest.func_226278_cu_() + (double)closest.func_70047_e() - (double)((float)this.field_174879_c.func_177956_o() + 0.5f);
            double dist = Utils.getDistanceAtoB((Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c), (Vec3D)new Vec3D(closest));
            float thRot = (float)MathHelper.func_181159_b((double)zDist, (double)xDist);
            float tyRot = (float)MathHelper.func_181159_b((double)dist, (double)yDist);
            this.hRot = thRot;
            if (this.hRot < 0.0f && (double)this.lthRot > 0.5) {
                this.hRot = (float)((double)this.hRot + Math.PI * 2);
            }
            this.yRot = tyRot;
            if ((double)(this.hRot - this.lthRot) > 0.5) {
                this.hRot = this.lthRot + 0.5f;
            } else if ((double)(this.hRot - this.lthRot) < -0.5) {
                this.hRot = this.lthRot - 0.5f;
            }
            if ((double)(this.yRot - this.ltyRot) > 0.1) {
                this.yRot = this.ltyRot + 0.1f;
            } else if ((double)(this.yRot - this.ltyRot) < -0.1) {
                this.yRot = this.ltyRot - 0.1f;
            }
        } else {
            this.hRot = (float)((double)this.hRot + 0.02);
            this.hRot %= (float)Math.PI * 2;
            if (this.hRot < 0.0f && (double)this.lthRot > 0.5) {
                this.hRot = (float)((double)this.hRot + Math.PI * 2);
            }
            if ((double)this.yRot % Math.PI > 1.5707963267948966) {
                this.yRot = (float)((double)this.yRot - 0.02);
            }
            if ((double)this.yRot % Math.PI < 1.5707963267948966) {
                this.yRot = (float)((double)this.yRot + 0.02);
            }
        }
        ParticleStarSpark spark = new ParticleStarSpark((ClientWorld)this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add((-0.5 + this.field_145850_b.field_73012_v.nextDouble()) * 0.1, 0.005, (-0.5 + this.field_145850_b.field_73012_v.nextDouble()) * 0.1));
        spark.setSizeAndRandMotion((double)0.4f * ((double)this.field_145850_b.field_73012_v.nextFloat() + 0.1), 0.02, 0.0, 0.02);
        spark.setMaxAge(30, 10);
        spark.setGravity(2.0E-4);
        spark.setAirResistance(0.02f);
        spark.setColour(0.0f, 1.0f, 1.0f);
        int i = this.field_145850_b.field_73012_v.nextInt(4);
        double x = i / 2;
        double z = i % 2;
        spark = new ParticleStarSpark((ClientWorld)this.field_145850_b, new Vec3D(this.field_174879_c).add(0.14 + x * 0.72, 0.17, 0.14 + z * 0.72));
        spark.setSizeAndRandMotion((double)0.3f * ((double)this.field_145850_b.field_73012_v.nextFloat() + 0.2), 0.002, 0.0, 0.002);
        spark.setGravity(2.0E-4);
        spark.sparkSize = 0.15f;
        if (this.isAdvanced()) {
            spark.setColour(1.0f, 0.7f, 0.0f);
        } else {
            spark.setColour(0.3f, 0.0f, 1.0f);
        }
    }

    public void doScanPulse() {
        List entities = this.entityFilter.filterEntities((Collection)this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)this.range.get(), (double)this.range.get(), (double)this.range.get())));
        double min = this.rsMinDetection.get() - 1;
        double max = this.rsMaxDetection.get();
        int eCount = entities.size();
        int output = min == max ? ((double)eCount > min ? 15 : 0) : (max - min == 15.0 ? (int)Math.max(0.0, Math.min(15.0, (double)eCount - min)) : (int)Math.max(0.0, Math.min(15.0, MathUtils.map((double)eCount, (double)min, (double)max, (double)0.0, (double)15.0))));
        if (this.outputStrength.get() != output) {
            this.outputStrength.set((int)((byte)output));
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        if (this.pulseRsMode.get()) {
            this.pulseDuration = 2;
        }
        this.opStorage.modifyEnergyStored((long)(-this.getPulseCost()));
    }

    public void adjustPulseRate(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 1 : 0);
    }

    public void adjustRange(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 3 : 2);
    }

    public void adjustRSMin(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 5 : 4);
    }

    public void adjustRSMax(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 7 : 6);
    }

    public void togglePulsemode() {
        this.sendPacketToServer(output -> output.writeBoolean(false), 8);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (id <= 8) {
            boolean decrement = data.readBoolean();
            boolean shift = id % 2 == 1;
            switch (id) {
                case 0: 
                case 1: {
                    short min = this.isAdvanced() ? (short)5 : 30;
                    short max = 1200;
                    int change = shift ? 100 : 5;
                    this.pulseRate.add(decrement ? (short)(-change) : (short)change);
                    if (this.pulseRate.get() < min) {
                        this.pulseRate.set(min);
                    } else if (this.pulseRate.get() > max) {
                        this.pulseRate.set(max);
                    }
                    this.pulseTimer = this.pulseRate.get();
                    break;
                }
                case 2: 
                case 3: {
                    short min = 1;
                    short max = this.isAdvanced() ? (short)64 : 16;
                    int change = shift ? 5 : 1;
                    this.range.add(decrement ? (short)(-change) : (short)change);
                    if (this.range.get() < min) {
                        this.range.set(min);
                        break;
                    }
                    if (this.range.get() <= max) break;
                    this.range.set(max);
                    break;
                }
                case 4: 
                case 5: {
                    int change = shift ? 5 : 1;
                    int value = this.rsMinDetection.add((int)(decrement ? (byte)(-change) : (byte)change));
                    int max = this.rsMaxDetection.get();
                    if (value < 0) {
                        value = 0;
                    } else if (value > max) {
                        value = max;
                    }
                    this.rsMinDetection.set((int)((byte)value));
                    break;
                }
                case 6: 
                case 7: {
                    int change = shift ? 5 : 1;
                    int value = this.rsMaxDetection.get() + (decrement ? -change : change);
                    int min = this.rsMinDetection.get();
                    if (value < min) {
                        value = min;
                    } else if (value > 127) {
                        value = 127;
                    }
                    this.rsMaxDetection.set((int)((byte)value));
                    break;
                }
                case 8: {
                    this.pulseRsMode.set(!this.pulseRsMode.get());
                }
            }
        }
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        MinecraftServer server;
        if (!this.field_145850_b.field_72995_K && (server = player.func_184102_h()) != null) {
            ListNBT list = new ListNBT();
            for (String name : server.func_184103_al().func_72369_d()) {
                list.add((Object)StringNBT.func_229705_a_((String)name));
            }
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("List", (INBT)list);
            this.sendPacketToClient((ServerPlayerEntity)player, output -> output.writeCompoundNBT(compound), 16);
        }
        return true;
    }

    public int getWeakPower(BlockState blockState, Direction side) {
        return this.outputStrength.get();
    }

    public int getStrongPower(BlockState blockState, Direction side) {
        return this.outputStrength.get();
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 16) {
            ListNBT list = data.readCompoundNBT().func_150295_c("List", 8);
            this.playerNames.clear();
            for (int i = 0; i < list.size(); ++i) {
                this.playerNames.add(list.func_150307_f(i));
            }
        }
    }

    public int getPulseCost() {
        return (int)(125.0 * Math.pow(this.range.get(), 1.5));
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }
}

