/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.ModHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileDissEnchanter
extends TileBCore {
    public TileItemStackHandler itemHandler = new TileItemStackHandler(3);

    public TileDissEnchanter() {
        super(DEContent.tile_disenchanter);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77948_v() && ModHelper.canRemoveEnchants(stack);
        }
        if (index == 1) {
            return stack.func_77973_b() == Items.field_151122_aG;
        }
        return false;
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int pid) {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack books = this.itemHandler.getStackInSlot(1);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        if (input.func_190926_b() || !input.func_77948_v() || books.func_190926_b() || books.func_190916_E() <= 0 || !output.func_190926_b()) {
            return;
        }
        ListNBT list = input.func_77986_q();
        if (list.isEmpty()) {
            return;
        }
        int targetId = data.readInt();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT stackCompound;
            CompoundNBT compound = list.func_150305_b(i);
            short id = compound.func_74765_d("id");
            short lvl = compound.func_74765_d("lvl");
            Enchantment e = Enchantment.func_185262_c((int)id);
            if (e == null || id != targetId) continue;
            int cost = (int)((double)lvl / (double)e.func_77325_b() * 20.0 * DEOldConfig.disenchnaterCostMultiplyer);
            if (!client.field_71075_bZ.field_75098_d && cost > client.field_71068_ca) {
                client.func_145747_a((ITextComponent)new TranslationTextComponent("chat.dissEnchanter.notEnoughLevels.msg", new Object[]{cost}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return;
            }
            if (!client.field_71075_bZ.field_75098_d) {
                client.func_82242_a(-cost);
            }
            if ((stackCompound = input.func_77978_p()) == null) {
                return;
            }
            books.func_190918_g(1);
            if (books.func_190916_E() <= 0) {
                this.itemHandler.setStackInSlot(1, ItemStack.field_190927_a);
            }
            int repairCost = stackCompound.func_74762_e("RepairCost");
            repairCost = (int)((double)repairCost - (double)repairCost * (1.0 / (double)list.size()));
            stackCompound.func_74768_a("RepairCost", repairCost);
            ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantedBookItem.func_92115_a((ItemStack)book, (EnchantmentData)new EnchantmentData(e, (int)lvl));
            this.itemHandler.setStackInSlot(2, book);
            list.remove(i);
            if (list.size() <= 0) {
                stackCompound.func_82580_o("ench");
            }
            return;
        }
    }
}

