/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.BoundDislocator;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDislocatorPedestal
extends TileBCore
implements DislocatorEndPoint,
IInteractTile {
    private static final ResourceLocation WOOL_TAG = new ResourceLocation("forge:wool");
    public final ManagedInt rotation = (ManagedInt)this.register((IManagedData)new ManagedInt("rotation", 0, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);

    public TileDislocatorPedestal() {
        super(DEContent.tile_dislocator_pedestal);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setSlotValidator(0, stack -> stack.func_77973_b() instanceof Dislocator);
    }

    public ActionResultType onBlockUse(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.field_145850_b.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!player.func_225608_bj_() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof Dislocator) {
                TargetPos location = ((Dislocator)stack.func_77973_b()).getTargetPos(stack, this.field_145850_b);
                if (location == null) {
                    if (BoundDislocator.isValid(stack)) {
                        if (BoundDislocator.isPlayer(stack)) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_player").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                        } else {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_target").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                boolean silenced = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().getTags().contains(WOOL_TAG);
                if (!silenced) {
                    BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
                BoundDislocator.notifyArriving(stack, player.field_70170_p, (Entity)player);
                location.teleport((Entity)player);
                if (!silenced) {
                    BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (PlayerEntity)player);
        this.detectAndSendChanges();
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack) && this.itemHandler.getStackInSlot(0).func_190926_b()) {
            DislocatorSaveData.updateLinkTarget(this.field_145850_b, stack, new PlayerTarget(player));
        }
        this.checkIn();
        this.func_70296_d();
        this.updateBlock();
        return ActionResultType.SUCCESS;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b instanceof ServerWorld) {
            this.checkIn();
        }
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
    }

    @Override
    @Nullable
    public Vector3d getArrivalPos(UUID linkID) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!BoundDislocator.isValid(stack) || !linkID.equals(BoundDislocator.getLinkId(stack))) {
            return null;
        }
        BlockPos pos = this.func_174877_v();
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (BoundDislocator.isValid(stack) && BoundDislocator.isP2P(stack)) {
            DislocatorSaveData.updateLinkTarget(this.field_145850_b, stack, new TileTarget(this));
        }
    }
}

