/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class StabilizedSpawnerLogic
extends AbstractSpawner {
    private TileStabilizedSpawner tile;
    private double mobRotation;
    private double prevMobRotation;
    private int spawnRange = 4;

    public StabilizedSpawnerLogic(TileStabilizedSpawner tile) {
        this.tile = tile;
    }

    @Nullable
    public ResourceLocation func_190895_g() {
        return new ResourceLocation(DEContent.mob_soul.getEntityString(this.tile.mobSoul.get()));
    }

    public void func_200876_a(EntityType<?> type) {
    }

    public void func_98278_g() {
        if (!this.func_98279_f()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            BlockPos blockpos = this.func_177221_b();
            World world = this.func_98271_a();
            if (world.field_72995_K) {
                double d3 = (float)blockpos.func_177958_n() + world.field_73012_v.nextFloat();
                double d4 = (float)blockpos.func_177956_o() + world.field_73012_v.nextFloat();
                double d5 = (float)blockpos.func_177952_p() + world.field_73012_v.nextFloat();
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d3, d4, d5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d3, d4, d5, 0.0, 0.0, 0.0);
                if (this.tile.spawnDelay.get() > 0) {
                    this.tile.spawnDelay.dec();
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.tile.spawnDelay.get() + 200.0f))) % 360.0;
            } else {
                if (this.tile.spawnDelay.get() == -1) {
                    this.resetTimer();
                }
                if (this.tile.spawnDelay.get() > 0) {
                    this.tile.spawnDelay.dec();
                    return;
                }
                TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
                boolean flag = false;
                int successCount = 0;
                for (int i = 0; i < tier.getSpawnCount() + tier.ordinal() + 3; ++i) {
                    Entity entity = DEContent.mob_soul.createEntity(world, this.tile.mobSoul.get());
                    do {
                        double spawnX = (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        double spawnY = blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                        double spawnZ = (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                        entity.func_70080_a(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                    } while (entity.func_233580_cy_().func_177958_n() == this.tile.func_174877_v().func_177958_n() && entity.func_233580_cy_().func_177952_p() == this.tile.func_174877_v().func_177952_p());
                    int nearbyCount = world.func_217357_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                    if (nearbyCount >= tier.getMaxCluster()) {
                        this.resetTimer();
                        return;
                    }
                    LivingEntity entityliving = entity instanceof LivingEntity ? (LivingEntity)entity : null;
                    entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving == null || !(entityliving instanceof MobEntity) || this.canEntitySpawnSpawner((MobEntity)entityliving, this.func_98271_a(), (float)entity.func_226277_ct_(), (float)entity.func_226278_cu_(), (float)entity.func_226281_cx_(), this)) {
                        if (!tier.requiresPlayer() && entity instanceof MobEntity) {
                            ((MobEntity)entity).func_110163_bv();
                            entity.getPersistentData().func_74772_a("DESpawnedMob", System.currentTimeMillis());
                            DEEventHandler.onMobSpawnedBySpawner((MobEntity)entity);
                        }
                        if (!((ServerWorld)world).func_242106_g(entity)) {
                            this.resetTimer();
                            return;
                        }
                        world.func_217379_c(2004, blockpos, 0);
                        if (entityliving != null) {
                            if (entity instanceof MobEntity) {
                                ((MobEntity)entity).func_70656_aK();
                            }
                            if (tier == TileStabilizedSpawner.SpawnerTier.CHAOTIC) {
                                double velocity = 2.5;
                                entity.func_213293_j((world.field_73012_v.nextDouble() - 0.5) * velocity, world.field_73012_v.nextDouble() * velocity, (world.field_73012_v.nextDouble() - 0.5) * velocity);
                            }
                        }
                        flag = true;
                        ++successCount;
                    }
                    if (successCount >= tier.getSpawnCount()) break;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    public boolean canEntitySpawnSpawner(MobEntity entity, World world, float x, float y, float z, AbstractSpawner spawner) {
        if (!MobSoul.isValidEntity((LivingEntity)entity)) {
            return false;
        }
        Event.Result result = ForgeEventFactory.canEntitySpawn((MobEntity)entity, (IWorld)world, (double)x, (double)y, (double)z, (AbstractSpawner)spawner, (SpawnReason)SpawnReason.SPAWNER);
        if (result == Event.Result.DEFAULT) {
            return (((TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get()).ignoreSpawnReq() || entity.func_213380_a((IWorld)world, SpawnReason.SPAWNER)) && entity.func_205019_a((IWorldReader)world);
        }
        return result == Event.Result.ALLOW;
    }

    private void resetTimer() {
        TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
        if (tier.getMaxDelay() <= tier.getMinDelay()) {
            this.tile.spawnDelay.set((short)tier.getMinDelay());
        } else {
            int i = tier.getMaxDelay() - tier.getMinDelay();
            this.tile.spawnDelay.set((short)(tier.getMinDelay() + this.func_98271_a().field_73012_v.nextInt(i)));
        }
        this.func_98267_a(1);
    }

    public boolean func_98268_b(int delay) {
        return false;
    }

    public Entity func_184994_d() {
        return this.tile.getRenderEntity();
    }

    public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177222_d() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177223_e() {
        return this.prevMobRotation;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return super.getSpawnerEntity();
    }

    public boolean func_98279_f() {
        return this.tile.isActive();
    }

    public void func_98267_a(int id) {
        this.tile.func_145831_w().func_175641_c(this.tile.func_174877_v(), Blocks.field_150474_ac, id, 0);
    }

    public World func_98271_a() {
        return this.tile.func_145831_w();
    }

    public BlockPos func_177221_b() {
        return this.tile.func_174877_v();
    }

    public CompoundNBT func_189530_b(CompoundNBT compound) {
        return compound;
    }

    public void func_98270_a(CompoundNBT nbt) {
    }
}

