/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXIO;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileCrystalDirectIO
extends TileCrystalBase {
    public final ManagedEnum<Direction> facing;
    public final ManagedBool outputMode;

    public TileCrystalDirectIO() {
        super(DEContent.tile_crystal_io);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    }

    public TileCrystalDirectIO(TechLevel techLevel) {
        super(DEContent.tile_crystal_io, techLevel);
        this.facing = (ManagedEnum)this.dataManager.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
        this.outputMode = (ManagedBool)this.dataManager.register((IManagedData)new ManagedBool("outputMode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((Direction)this.facing.get()));
        if (this.outputMode.get() && tile != null) {
            this.opStorage.extractOP(EnergyUtils.insertEnergy((TileEntity)tile, (long)this.opStorage.extractOP(this.opStorage.getMaxExtract(), true), (Direction)((Direction)this.facing.get()).func_176734_d(), (boolean)false), false);
        }
    }

    @Override
    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            this.outputMode.invert();
            this.updateRotation((Direction)this.facing.get());
            return true;
        }
        return super.onBlockActivated(state, player, handIn, hit);
    }

    @Override
    public EnergyCrystal.CrystalType getCrystalType() {
        return EnergyCrystal.CrystalType.CRYSTAL_IO;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CrystalFXBase createStaticFX() {
        return new CrystalFXIO((ClientWorld)this.field_145850_b, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        return Vec3D.getCenter((BlockPos)this.field_174879_c);
    }

    @Override
    public boolean renderBeamTermination() {
        return false;
    }

    @Override
    public void addDisplayData(List<ITextComponent> displayList) {
        super.addDisplayData(displayList);
        TextFormatting colour = this.outputMode.get() ? TextFormatting.GOLD : TextFormatting.DARK_AQUA;
        displayList.add((ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.io_output_" + this.outputMode.get(), new Object[]{colour}));
    }

    @Override
    public void onTilePlaced(BlockItemUseContext context, BlockState state) {
        super.onTilePlaced(context, state);
        this.updateRotation(context.func_196000_l().func_176734_d());
    }

    public void updateRotation(Direction newDirection) {
        this.facing.set((Enum)newDirection);
        this.capManager.remove(CapabilityOP.OP, new Direction[0]);
        this.opStorage.setIOMode(!this.outputMode.get());
        this.capManager.setSide(CapabilityOP.OP, (Object)this.opStorage, newDirection);
    }

    @Override
    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        this.updateRotation((Direction)this.facing.get());
    }
}

