/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.hud.IHudBlock;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalRelay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EnergyCrystal
extends BlockBCore
implements IHudBlock {
    private final TechLevel techLevel;
    private final CrystalType crystalType;
    private static VoxelShape CRYSTAL_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.125, 0.375, 0.625, 0.875, 0.625));
    private static VoxelShape[] IO_CRYSTAL_SHAPES = new VoxelShape[6];

    public EnergyCrystal(AbstractBlock.Properties properties, TechLevel techLevel, CrystalType crystalType) {
        super(properties);
        this.techLevel = techLevel;
        this.crystalType = crystalType;
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_149666_a(group, items);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (this.crystalType == CrystalType.CRYSTAL_IO) {
            TileEntity tile = world.func_175625_s(pos);
            Direction facing = tile instanceof TileCrystalDirectIO ? (Direction)((TileCrystalDirectIO)tile).facing.get() : Direction.DOWN;
            return IO_CRYSTAL_SHAPES[facing.func_176745_a()];
        }
        return CRYSTAL_SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.crystalType.createTile(this.techLevel);
    }

    public void generateHudText(World world, BlockPos pos, PlayerEntity player, List<ITextComponent> displayList) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileCrystalBase)) {
            return;
        }
        displayList.add((ITextComponent)new TranslationTextComponent(this.func_199767_j().func_77658_a()).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GOLD}));
        TileCrystalBase tile = (TileCrystalBase)te;
        tile.addDisplayData(displayList);
    }

    static {
        for (Direction dir : Direction.values()) {
            Cuboid6 c = new Cuboid6(0.35, 0.0, 0.35, 0.65, 0.425, 0.65);
            c.apply(Rotation.sideRotations[dir.func_176745_a()].at(Vector3.CENTER));
            EnergyCrystal.IO_CRYSTAL_SHAPES[dir.func_176745_a()] = VoxelShapes.func_197881_a((AxisAlignedBB)c.aabb());
        }
    }

    public static enum CrystalType implements IStringSerializable
    {
        RELAY(0){

            @Override
            public TileEntity createTile(TechLevel techLevel) {
                return new TileCrystalRelay(techLevel);
            }
        }
        ,
        CRYSTAL_IO(1){

            @Override
            public TileEntity createTile(TechLevel techLevel) {
                return new TileCrystalDirectIO(techLevel);
            }
        }
        ,
        WIRELESS(2){

            @Override
            public TileEntity createTile(TechLevel techLevel) {
                return new TileCrystalWirelessIO(techLevel);
            }
        };

        private final int index;

        private CrystalType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        private static CrystalType fromIndex(int i) {
            return i == 0 ? RELAY : (i == 1 ? CRYSTAL_IO : WIRELESS);
        }

        public static CrystalType fromMeta(int meta) {
            return CrystalType.fromIndex(meta / 3);
        }

        public int getMeta(int tier) {
            return this.getIndex() * 3 + tier;
        }

        public static int getTier(int meta) {
            return meta % 3;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public abstract TileEntity createTile(TechLevel var1);
    }
}

