/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.data;

import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ProjectileData
implements ModuleData<ProjectileData> {
    private final float velocity;
    private final float accuracy;
    private final float antiGrav;
    private final float penetration;
    private final float damage;

    public ProjectileData(float velocity, float accuracy, float antiGrav, float penetration, float damage) {
        this.accuracy = accuracy;
        this.antiGrav = antiGrav;
        this.penetration = penetration;
        this.velocity = velocity;
        this.damage = damage;
    }

    public float getAccuracy() {
        return this.accuracy > 1.0f ? 1.0f : this.accuracy;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getAntiGrav() {
        return this.antiGrav > 1.0f ? 1.0f : this.antiGrav;
    }

    public float getPenetration() {
        return this.penetration;
    }

    public float getDamage() {
        return this.damage;
    }

    @Override
    public ProjectileData combine(ProjectileData other) {
        return new ProjectileData(this.velocity + other.velocity, this.accuracy + other.accuracy, this.antiGrav + other.antiGrav, this.penetration + other.penetration, this.damage + other.damage);
    }

    @Override
    public void addInformation(Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        if (this.getVelocity() != 0.0f) {
            int vel = Math.round(this.getVelocity() * 100.0f);
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_velocity.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_velocity.value", new Object[]{vel > 0 ? "+" + vel : Integer.valueOf(vel), Math.round(60.0f * (this.getVelocity() + 1.0f))}));
        }
        if (this.getAccuracy() != 0.0f) {
            int acc = Math.round(this.getAccuracy() * -100.0f);
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_accuracy.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_accuracy.value", new Object[]{acc > 0 ? "+" + acc : Integer.valueOf(acc)}));
        }
        if (this.getAntiGrav() != 0.0f) {
            int antiGrav = Math.round(this.getAntiGrav() * 100.0f);
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_grav_comp.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_grav_comp.value", new Object[]{antiGrav > 0 ? "+" + antiGrav : Integer.valueOf(antiGrav)}));
        }
        if (this.getPenetration() > 0.0f && (this.getPenetration() > this.getVelocity() || !stack)) {
            int pen = Math.round(this.getPenetration() * 100.0f);
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_penetration.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_penetration.value", new Object[]{pen > 0 ? "+" + pen : Integer.valueOf(pen)}));
            if (stack) {
                map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_penetration.info"), null);
                map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_penetration.info2"), null);
            }
        }
        if (this.getDamage() != 0.0f) {
            int damage = Math.round(this.getDamage() * 100.0f);
            map.put((ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_damage.name"), (ITextComponent)new TranslationTextComponent("module.draconicevolution.proj_damage.value", new Object[]{damage > 0 ? "+" + damage : Integer.valueOf(damage)}));
        }
    }
}

