/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.capability;

import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.EnumProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public interface PropertyProvider
extends INBTSerializable<CompoundNBT> {
    public UUID getProviderID();

    public String getProviderName();

    public void regenProviderID();

    public Collection<ConfigProperty> getProperties();

    @Nullable
    public ConfigProperty getProperty(String var1);

    default public boolean hasProperty(String propertyName) {
        return this.getProperty(propertyName) != null;
    }

    default public boolean hasBool(String propertyName) {
        return this.getProperty(propertyName) instanceof BooleanProperty;
    }

    default public boolean hasDecimal(String propertyName) {
        return this.getProperty(propertyName) instanceof DecimalProperty;
    }

    default public boolean hasInt(String propertyName) {
        return this.getProperty(propertyName) instanceof IntegerProperty;
    }

    default public boolean hasEnum(String propertyName) {
        return this.getProperty(propertyName) instanceof EnumProperty;
    }

    default public BooleanProperty getBool(String propertyName) {
        return (BooleanProperty)this.getProperty(propertyName);
    }

    default public DecimalProperty getDecimal(String propertyName) {
        return (DecimalProperty)this.getProperty(propertyName);
    }

    default public IntegerProperty getInt(String propertyName) {
        return (IntegerProperty)this.getProperty(propertyName);
    }

    default public EnumProperty<?> getEnum(String propertyName) {
        return (EnumProperty)this.getProperty(propertyName);
    }
}

