/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.capability;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;

public interface ModuleHost
extends INBTSerializable<CompoundNBT> {
    public Stream<Module<?>> getModules();

    public List<ModuleEntity> getModuleEntities();

    public void addModule(ModuleEntity var1, ModuleContext var2);

    public void removeModule(ModuleEntity var1, ModuleContext var2);

    default public boolean isModuleSupported(ModuleEntity entity) {
        Module<?> module = entity.getModule();
        ModuleType<?> type = module.getType();
        if (this.getTypeBlackList().contains(type)) {
            return false;
        }
        if (this.getAdditionalTypes().contains(type) || module.getCategories().contains(ModuleCategory.ALL)) {
            return true;
        }
        Collection<ModuleCategory> hostCats = this.getModuleCategories();
        for (ModuleCategory cat : module.getCategories()) {
            if (!hostCats.contains(cat)) continue;
            return true;
        }
        return false;
    }

    public Collection<ModuleCategory> getModuleCategories();

    default public Collection<ModuleType<?>> getAdditionalTypes() {
        return Collections.emptyList();
    }

    default public Collection<ModuleType<?>> getTypeBlackList() {
        return Collections.emptyList();
    }

    public TechLevel getHostTechLevel();

    public int getGridWidth();

    public int getGridHeight();

    @Nullable
    default public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType) {
        return (T)((ModuleData)this.getModules().filter(module -> module.getType() == moduleType).map(Module::getData).reduce((o1, other) -> o1.combine(other)).orElse(null));
    }

    default public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType, T fallback) {
        T data = this.getModuleData(moduleType);
        return data == null ? fallback : data;
    }

    default public Stream<ModuleEntity> getEntitiesByType(ModuleType<?> moduleType) {
        return this.getModuleEntities().stream().filter(e -> e.getModule().getType() == moduleType);
    }

    default public Stream<ModuleType<?>> getInstalledTypes() {
        return this.getModules().map(Module::getType);
    }

    default public <T extends ModuleData<T>> void getDataInformation(T moduleData, Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        if (moduleData == null) {
            return;
        }
        moduleData.addInformation(map, context, stack);
    }

    default public void addInformation(Map<ITextComponent, ITextComponent> map, ModuleContext context, boolean stack) {
        this.getInstalledTypes().map(this::getModuleData).forEach(data -> this.getDataInformation((ModuleData)SneakyUtils.unsafeCast((Object)data), map, context, stack));
    }

    public static InstallResult checkAddModule(ModuleHost host, Module<?> newModule) {
        return newModule.doInstallationCheck(host.getModules());
    }

    public void handleTick(ModuleContext var1);
}

