/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.capability;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ItemCapabilityProvider<T extends INBTSerializable<CompoundNBT>>
implements ICapabilitySerializable<CompoundNBT> {
    private T capability;

    public ItemCapabilityProvider(T capability) {
        this.capability = capability;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == DECapabilities.MODULE_HOST_CAPABILITY && this.capability instanceof ModuleHost || cap == DECapabilities.PROPERTY_PROVIDER_CAPABILITY && this.capability instanceof PropertyProvider) {
            return LazyOptional.of(() -> this.capability).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.capability.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.capability.deserializeNBT((INBT)nbt);
    }
}

