/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RayTraceHelper {
    public static final RayTracer<BlockRayTraceResult> BLOCK_RAY_TRACER = new RayTracer<BlockRayTraceResult>(){

        @Override
        @Nullable
        public BlockRayTraceResult trace(World world, double x, double y, double z, BlockPos pos, Tuple<Vector3d, Vector3d> ray, RayTraceOptions options) {
            BlockState blockstate = world.func_180495_p(pos);
            FluidState fluidstate = world.func_204610_c(pos);
            VoxelShape blockShape = options.getBlockShape((IBlockReader)world, pos, blockstate);
            BlockRayTraceResult blockResult = world.func_217296_a((Vector3d)ray.func_76341_a(), (Vector3d)ray.func_76340_b(), pos, blockShape, blockstate);
            VoxelShape fluidShape = options.getFluidShape((IBlockReader)world, pos, fluidstate);
            BlockRayTraceResult fluidResult = fluidShape.func_212433_a((Vector3d)ray.func_76341_a(), (Vector3d)ray.func_76340_b(), pos);
            double d0 = blockResult == null ? Double.MAX_VALUE : ((Vector3d)ray.func_76341_a()).func_72436_e(blockResult.func_216347_e());
            double d1 = fluidResult == null ? Double.MAX_VALUE : ((Vector3d)ray.func_76340_b()).func_72436_e(fluidResult.func_216347_e());
            return d0 <= d1 ? blockResult : fluidResult;
        }

        @Override
        public BlockRayTraceResult createMiss(Tuple<Vector3d, Vector3d> ray) {
            Vector3d vector3d = ((Vector3d)ray.func_76341_a()).func_178788_d((Vector3d)ray.func_76340_b());
            return BlockRayTraceResult.func_216352_a((Vector3d)((Vector3d)ray.func_76340_b()), (Direction)Direction.func_210769_a((double)vector3d.field_72450_a, (double)vector3d.field_72448_b, (double)vector3d.field_72449_c), (BlockPos)new BlockPos((Vector3d)ray.func_76340_b()));
        }
    };
    public static final RayTracer<EntityRayTraceResult> ENTITY_RAY_TRACER = new RayTracer<EntityRayTraceResult>(){

        @Override
        @Nullable
        public EntityRayTraceResult trace(World world, double x, double y, double z, BlockPos pos, Tuple<Vector3d, Vector3d> ray, RayTraceOptions options) {
            Entity hit = options.getHitEntity(world, x, y, z, ray);
            return hit == null ? null : new EntityRayTraceResult(hit, new Vector3d(x, y, z));
        }

        @Override
        public EntityRayTraceResult createMiss(Tuple<Vector3d, Vector3d> ray) {
            return new EntityRayTraceResultMiss((Vector3d)ray.func_76340_b());
        }
    };
    public static final RayTracer<RayTraceResult> GENERAL_RAY_TRACER = new RayTracer<RayTraceResult>(){

        @Override
        @Nullable
        public RayTraceResult trace(World world, double x, double y, double z, BlockPos pos, Tuple<Vector3d, Vector3d> ray, RayTraceOptions options) {
            EntityRayTraceResult entityResult = ENTITY_RAY_TRACER.trace(world, x, y, z, pos, ray, options);
            if (entityResult != null) {
                return entityResult;
            }
            return BLOCK_RAY_TRACER.trace(world, x, y, z, pos, ray, options);
        }

        @Override
        public RayTraceResult createMiss(Tuple<Vector3d, Vector3d> ray) {
            return BLOCK_RAY_TRACER.createMiss(ray);
        }
    };

    public static Optional<BlockRayTraceResult> getTargetBlock(Entity entity, double distance) {
        return RayTraceHelper.getRayFromEyesAndDistance(entity, distance).flatMap(ray -> RayTraceHelper.rayTraceBlockForEntity(entity, entity.func_130014_f_(), (Tuple<Vector3d, Vector3d>)ray, false, false));
    }

    public static Optional<EntityRayTraceResult> getTargetEntity(Entity entity, double distance) {
        return RayTraceHelper.getTargetEntity(entity, distance, Entity.class);
    }

    public static Optional<EntityRayTraceResult> getTargetEntity(Entity entity, double distance, Class<? extends Entity> entityClass) {
        return RayTraceHelper.getTargetEntity(entity, distance, new PredicateInstanceOf<Entity>(entityClass));
    }

    public static Optional<EntityRayTraceResult> getTargetEntity(Entity entity, double distance, Predicate<? super Entity> filter) {
        return RayTraceHelper.getRayFromEyesAndDistance(entity, distance).flatMap(ray -> RayTraceHelper.rayTraceEntityForEntity(entity, entity.func_130014_f_(), (Tuple<Vector3d, Vector3d>)ray, false, false, filter));
    }

    public static Optional<RayTraceResult> getTargetEntityOrBlock(Entity entity, double distance) {
        return RayTraceHelper.getTargetEntityOrBlock(entity, distance, Entity.class);
    }

    public static Optional<RayTraceResult> getTargetEntityOrBlock(Entity entity, double distance, Class<? extends Entity> entityClass) {
        return RayTraceHelper.getTargetEntityOrBlock(entity, distance, new PredicateInstanceOf<Entity>(entityClass));
    }

    public static Optional<RayTraceResult> getTargetEntityOrBlock(Entity entity, double distance, Predicate<? super Entity> filter) {
        return RayTraceHelper.getRayFromEyesAndDistance(entity, distance).flatMap(ray -> RayTraceHelper.rayTraceForEntity(entity, entity.func_130014_f_(), (Tuple<Vector3d, Vector3d>)ray, false, false, filter));
    }

    public static Optional<BlockRayTraceResult> rayTraceBlockForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable) {
        RayTraceOptions.Builder optionBuilder = RayTraceHelper.getOptionBuilder().forEntity(entity);
        if (stopOnLiquid) {
            optionBuilder.stopOnAnyLiquid();
        } else {
            optionBuilder.ignoreLiquid();
        }
        if (ignoreUncollidable) {
            optionBuilder.ignoreUnCollidableBlocks();
        } else {
            optionBuilder.useUnCollidableBlocks();
        }
        return Optional.ofNullable(RayTraceHelper.doRayTrace(world, ray, optionBuilder.build(), BLOCK_RAY_TRACER));
    }

    public static Optional<EntityRayTraceResult> rayTraceEntityForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable) {
        return RayTraceHelper.rayTraceEntityForEntity(entity, world, ray, stopOnLiquid, ignoreUncollidable, Entity.class);
    }

    public static Optional<EntityRayTraceResult> rayTraceEntityForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable, Class<? extends Entity> entityClass) {
        return RayTraceHelper.rayTraceEntityForEntity(entity, world, ray, stopOnLiquid, ignoreUncollidable, new PredicateInstanceOf<Entity>(entityClass));
    }

    public static Optional<EntityRayTraceResult> rayTraceEntityForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable, Predicate<? super Entity> filter) {
        RayTraceOptions.Builder optionBuilder = RayTraceHelper.getOptionBuilder().forEntity(entity);
        optionBuilder.setEntityFilter(filter);
        if (stopOnLiquid) {
            optionBuilder.stopOnAnyLiquid();
        } else {
            optionBuilder.ignoreLiquid();
        }
        if (ignoreUncollidable) {
            optionBuilder.ignoreUnCollidableBlocks();
        } else {
            optionBuilder.useUnCollidableBlocks();
        }
        return Optional.ofNullable(RayTraceHelper.doRayTrace(world, ray, optionBuilder.build(), ENTITY_RAY_TRACER));
    }

    public static Optional<RayTraceResult> rayTraceForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable) {
        return RayTraceHelper.rayTraceForEntity(entity, world, ray, stopOnLiquid, ignoreUncollidable, Entity.class);
    }

    public static Optional<RayTraceResult> rayTraceForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable, Class<? extends Entity> entityClass) {
        return RayTraceHelper.rayTraceForEntity(entity, world, ray, stopOnLiquid, ignoreUncollidable, new PredicateInstanceOf<Entity>(entityClass));
    }

    public static Optional<RayTraceResult> rayTraceForEntity(Entity entity, World world, Tuple<Vector3d, Vector3d> ray, boolean stopOnLiquid, boolean ignoreUncollidable, Predicate<? super Entity> filter) {
        RayTraceOptions.Builder optionBuilder = RayTraceHelper.getOptionBuilder().forEntity(entity);
        optionBuilder.setEntityFilter(filter);
        if (stopOnLiquid) {
            optionBuilder.stopOnAnyLiquid();
        } else {
            optionBuilder.ignoreLiquid();
        }
        if (ignoreUncollidable) {
            optionBuilder.ignoreUnCollidableBlocks();
        } else {
            optionBuilder.useUnCollidableBlocks();
        }
        return Optional.ofNullable(RayTraceHelper.doRayTrace(world, ray, optionBuilder.build(), GENERAL_RAY_TRACER));
    }

    @Nullable
    private static <T extends RayTraceResult> T doRayTrace(World world, Tuple<Vector3d, Vector3d> ray, RayTraceOptions options, RayTracer<T> rayTracer) {
        int z_0;
        int y_0;
        int x_0;
        BlockPos.Mutable mutable_pos;
        double z_1;
        double y_1;
        Vector3d stop;
        Vector3d start = (Vector3d)ray.func_76341_a();
        if (start.equals((Object)(stop = (Vector3d)ray.func_76340_b()))) {
            return rayTracer.createMiss(ray);
        }
        double x_1 = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72450_a, (double)stop.field_72450_a);
        T result = rayTracer.trace(world, x_1, y_1 = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72448_b, (double)stop.field_72448_b), z_1 = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72449_c, (double)stop.field_72449_c), (BlockPos)(mutable_pos = new BlockPos.Mutable(x_0 = MathHelper.func_76128_c((double)x_1), y_0 = MathHelper.func_76128_c((double)y_1), z_0 = MathHelper.func_76128_c((double)z_1))), ray, options);
        if (result != null) {
            return result;
        }
        double x_2 = MathHelper.func_219803_d((double)-1.0E-7, (double)stop.field_72450_a, (double)start.field_72450_a);
        double y_2 = MathHelper.func_219803_d((double)-1.0E-7, (double)stop.field_72448_b, (double)start.field_72448_b);
        double z_2 = MathHelper.func_219803_d((double)-1.0E-7, (double)stop.field_72449_c, (double)start.field_72449_c);
        double dx = x_2 - x_1;
        double dy = y_2 - y_1;
        double dz = z_2 - z_1;
        int xSign = MathHelper.func_219802_k((double)dx);
        int ySign = MathHelper.func_219802_k((double)dy);
        int zSign = MathHelper.func_219802_k((double)dz);
        double dxInv = xSign == 0 ? Double.MAX_VALUE : (double)xSign / dx;
        double dyInv = ySign == 0 ? Double.MAX_VALUE : (double)ySign / dy;
        double dzInv = zSign == 0 ? Double.MAX_VALUE : (double)zSign / dz;
        double progress_x = dxInv * (xSign > 0 ? 1.0 - MathHelper.func_181162_h((double)x_1) : MathHelper.func_181162_h((double)x_1));
        double progress_y = dyInv * (ySign > 0 ? 1.0 - MathHelper.func_181162_h((double)y_1) : MathHelper.func_181162_h((double)y_1));
        double progress_z = dzInv * (zSign > 0 ? 1.0 - MathHelper.func_181162_h((double)z_1) : MathHelper.func_181162_h((double)z_1));
        while (progress_x <= 1.0 || progress_y <= 1.0 || progress_z <= 1.0) {
            if (progress_x < progress_y) {
                if (progress_x < progress_z) {
                    x_0 += xSign;
                    progress_x += dxInv;
                } else {
                    z_0 += zSign;
                    progress_z += dzInv;
                }
            } else if (progress_y < progress_z) {
                y_0 += ySign;
                progress_y += dyInv;
            } else {
                z_0 += zSign;
                progress_z += dzInv;
            }
            if ((result = rayTracer.trace(world, x_1 + progress_x * dx, y_1 + progress_y * dy, z_1 + progress_z * dz, (BlockPos)mutable_pos.func_181079_c(x_0, y_0, z_0), ray, options)) == null) continue;
            return result;
        }
        return rayTracer.createMiss(ray);
    }

    private static Optional<Tuple<Vector3d, Vector3d>> getRayFromEyesAndDistance(Entity entity, double distance) {
        if (entity == null && !entity.func_70089_S()) {
            return Optional.empty();
        }
        Vector3d eyes = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d look = entity.func_70040_Z();
        if (look == null) {
            return Optional.empty();
        }
        Vector3d trace = eyes.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        return Optional.of(new Tuple((Object)eyes, (Object)trace));
    }

    public static RayTraceOptions.Builder getOptionBuilder() {
        return new RayTraceOptions.Builder();
    }

    private static final class EntityRayTraceResultMiss
    extends EntityRayTraceResult {
        public EntityRayTraceResultMiss(Vector3d hitVec) {
            super(null, hitVec);
        }

        @Nonnull
        public RayTraceResult.Type func_216346_c() {
            return RayTraceResult.Type.MISS;
        }
    }

    public static abstract class RayTracer<T extends RayTraceResult> {
        @Nullable
        public abstract T trace(World var1, double var2, double var4, double var6, BlockPos var8, Tuple<Vector3d, Vector3d> var9, RayTraceOptions var10);

        public abstract T createMiss(Tuple<Vector3d, Vector3d> var1);
    }

    public static class RayTraceOptions {
        private final RayTraceContext.BlockMode blockMode;
        private final RayTraceContext.FluidMode fluidMode;
        private final ISelectionContext context;
        private final Predicate<? super Entity> entityFilter;

        private RayTraceOptions(RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, ISelectionContext context, Predicate<? super Entity> entityFilter) {
            this.blockMode = blockMode;
            this.fluidMode = fluidMode;
            this.context = context;
            this.entityFilter = entityFilter;
        }

        public VoxelShape getBlockShape(IBlockReader world, BlockPos pos, BlockState state) {
            return this.blockMode.get(state, world, pos, this.context);
        }

        public VoxelShape getFluidShape(IBlockReader world, BlockPos pos, FluidState state) {
            return this.fluidMode.func_222248_a(state) ? state.func_215676_d(world, pos) : VoxelShapes.func_197880_a();
        }

        @Nullable
        public Entity getHitEntity(World world, double x, double y, double z, Tuple<Vector3d, Vector3d> ray) {
            double d = 0.25;
            AxisAlignedBB area = new AxisAlignedBB(x - d, y - d, z - d, x + d, y + d, z + d);
            List entities = world.func_175674_a(this.context.getEntity(), area, this.entityFilter);
            Entity closest = null;
            double dist = 998001.0;
            for (Entity collided : entities) {
                double distTo = (collided.func_226277_ct_() - ((Vector3d)ray.func_76341_a()).field_72450_a) * (collided.func_226277_ct_() - ((Vector3d)ray.func_76341_a()).field_72450_a) + (collided.func_226278_cu_() - ((Vector3d)ray.func_76341_a()).field_72448_b) * (collided.func_226278_cu_() - ((Vector3d)ray.func_76341_a()).field_72448_b) + (collided.func_226281_cx_() - ((Vector3d)ray.func_76341_a()).field_72449_c) * (collided.func_226281_cx_() - ((Vector3d)ray.func_76341_a()).field_72449_c);
                if (!(distTo < dist)) continue;
                dist = distTo;
                closest = collided;
            }
            return closest;
        }

        public static class Builder {
            RayTraceContext.BlockMode blockMode = RayTraceContext.BlockMode.OUTLINE;
            RayTraceContext.FluidMode fluidMode = RayTraceContext.FluidMode.NONE;
            ISelectionContext context = ISelectionContext.func_216377_a();
            Predicate<? super Entity> entityFilter = Predicates.alwaysTrue();

            private Builder() {
            }

            public Builder forEntity(Entity entity) {
                this.context = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
                return this;
            }

            public Builder setEntityFilter(Predicate<? super Entity> filter) {
                this.entityFilter = filter;
                return this;
            }

            public Builder ignoreUnCollidableBlocks() {
                this.blockMode = RayTraceContext.BlockMode.COLLIDER;
                return this;
            }

            public Builder useUnCollidableBlocks() {
                this.blockMode = RayTraceContext.BlockMode.OUTLINE;
                return this;
            }

            public Builder useBlockVisual() {
                this.blockMode = RayTraceContext.BlockMode.VISUAL;
                return this;
            }

            public Builder ignoreLiquid() {
                this.fluidMode = RayTraceContext.FluidMode.NONE;
                return this;
            }

            public Builder stopOnLiquidSource() {
                this.fluidMode = RayTraceContext.FluidMode.SOURCE_ONLY;
                return this;
            }

            public Builder stopOnAnyLiquid() {
                this.fluidMode = RayTraceContext.FluidMode.ANY;
                return this;
            }

            public RayTraceOptions build() {
                return new RayTraceOptions(this.blockMode, this.fluidMode, this.context, this.entityFilter);
            }
        }
    }

    public static class PredicateInstanceOf<E extends Entity>
    implements Predicate<E> {
        private final Class<E> entityClass;

        public PredicateInstanceOf(Class<E> entityClass) {
            this.entityClass = entityClass;
        }

        public boolean apply(@Nullable Entity e) {
            return e != null && this.entityClass.isAssignableFrom(e.getClass());
        }
    }
}

